/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal.radio;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioApiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontierSiliconRadioConnection {
    private final Logger logger = LoggerFactory.getLogger(FrontierSiliconRadioConnection.class);
    private static final int SOCKET_TIMEOUT = 5000;
    private final String hostname;
    private final int port;
    private final String pin;
    private String sessionId;
    private HttpClient httpClient = null;
    private boolean isLoggedIn = false;

    public FrontierSiliconRadioConnection(String hostname, int port, String pin) {
        this.hostname = hostname;
        this.port = port;
        this.pin = pin;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    protected void close() {
        this.stopHttpClient(this.httpClient);
    }

    public boolean doLogin() throws IOException {
        this.isLoggedIn = false;
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        this.startHttpClient(this.httpClient);
        String url = "http://" + this.hostname + ":" + this.port + "/fsapi" + "/CREATE_SESSION?pin=" + this.pin;
        this.logger.trace("opening URL: {}", (Object)url);
        Request request = this.httpClient.newRequest(url).method(HttpMethod.GET).timeout(5000L, TimeUnit.MILLISECONDS);
        try {
            FrontierSiliconRadioApiResult result;
            ContentResponse response = request.send();
            int statusCode = response.getStatus();
            if (statusCode != 200) {
                String reason = response.getReason();
                this.logger.debug("Communication with radio failed: {} {}", (Object)statusCode, (Object)reason);
                if (statusCode == 403) {
                    throw new RuntimeException("Radio does not allow connection, maybe wrong pin?");
                }
                throw new IOException("Communication with radio failed, return code: " + statusCode);
            }
            String responseBody = response.getContentAsString();
            if (!responseBody.isEmpty()) {
                this.logger.trace("login response: {}", (Object)responseBody);
            }
            if ((result = new FrontierSiliconRadioApiResult(responseBody)).isStatusOk()) {
                this.logger.trace("login successful");
                this.sessionId = result.getSessionId();
                this.isLoggedIn = true;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.debug("Fatal transport error: {}", (Object)e.toString());
            throw new IOException(e);
        }
        return false;
    }

    public FrontierSiliconRadioApiResult doRequest(String requestString) throws IOException {
        return this.doRequest(requestString, null);
    }

    public FrontierSiliconRadioApiResult doRequest(String requestString, String params) throws IOException {
        int i = 0;
        while (i < 3) {
            if (this.isLoggedIn || this.doLogin()) {
                String url = "http://" + this.hostname + ":" + this.port + "/fsapi" + "/" + requestString + "?pin=" + this.pin + "&sid=" + this.sessionId + (params == null || params.trim().length() == 0 ? "" : "&" + params);
                this.logger.trace("calling url: '{}'", (Object)url);
                this.startHttpClient(this.httpClient);
                Request request = this.httpClient.newRequest(url).method(HttpMethod.GET).timeout(5000L, TimeUnit.MILLISECONDS);
                try {
                    ContentResponse response = request.send();
                    int statusCode = response.getStatus();
                    if (statusCode != 200) {
                        if (i >= 2) {
                            String reason = response.getReason();
                            this.logger.warn("Method failed: {}  {}", (Object)statusCode, (Object)reason);
                        }
                        this.isLoggedIn = false;
                    } else {
                        String responseBody = response.getContentAsString();
                        if (responseBody.isEmpty()) {
                            this.logger.debug("got empty result");
                            this.isLoggedIn = false;
                        } else {
                            this.logger.trace("got result: {}", (Object)responseBody);
                            FrontierSiliconRadioApiResult result = new FrontierSiliconRadioApiResult(responseBody);
                            if (result.isStatusOk()) {
                                return result;
                            }
                            this.isLoggedIn = false;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("Fatal transport error: {}", (Object)e.toString());
                    throw new IOException(e);
                }
            }
            ++i;
        }
        this.isLoggedIn = false;
        return null;
    }

    private void startHttpClient(HttpClient client) {
        if (!client.isStarted()) {
            try {
                client.start();
            }
            catch (Exception e1) {
                this.logger.warn("Can not start HttpClient !", (Throwable)e1);
            }
        }
    }

    private void stopHttpClient(HttpClient client) {
        if (client.isStarted()) {
            try {
                client.stop();
            }
            catch (Exception e) {
                this.logger.error("Unable to stop HttpClient !", (Throwable)e);
            }
        }
    }
}

