/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.Light;

@NonNullByDefault
class Util {
    private Util() {
    }

    public static int stringSize(String str) {
        try {
            return str.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 not supported");
        }
    }

    public static List<Light> idsToLights(List<String> ids) {
        ArrayList<Light> lights = new ArrayList<Light>();
        for (String id : ids) {
            Light light = new Light();
            light.setId(id);
            lights.add(light);
        }
        return lights;
    }

    public static List<String> lightsToIds(List<Light> lights) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Light light : lights) {
            ids.add(light.getId());
        }
        return ids;
    }

    public static @Nullable String quickMatch(String needle, String haystack) {
        Matcher m = Pattern.compile(needle).matcher(haystack);
        m.find();
        return m.group(1);
    }
}

