/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.discovery;

import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.handler.HueLightHandler;
import org.eclipse.smarthome.binding.hue.handler.LightStatusListener;
import org.eclipse.smarthome.binding.hue.internal.FullLight;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HueLightDiscoveryService
extends AbstractDiscoveryService
implements LightStatusListener {
    private final Logger logger = LoggerFactory.getLogger(HueLightDiscoveryService.class);
    private static final int SEARCH_TIME = 60;
    private static final Map<String, @Nullable String> TYPE_TO_ZIGBEE_ID_MAP = Stream.of(new AbstractMap.SimpleEntry<String, String>("on_off_light", "0000"), new AbstractMap.SimpleEntry<String, String>("on_off_plug_in_unit", "0010"), new AbstractMap.SimpleEntry<String, String>("dimmable_light", "0100"), new AbstractMap.SimpleEntry<String, String>("dimmable_plug_in_unit", "0110"), new AbstractMap.SimpleEntry<String, String>("color_light", "0200"), new AbstractMap.SimpleEntry<String, String>("extended_color_light", "0210"), new AbstractMap.SimpleEntry<String, String>("color_temperature_light", "0220")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    private final HueBridgeHandler hueBridgeHandler;

    public HueLightDiscoveryService(HueBridgeHandler hueBridgeHandler) {
        super(60);
        this.hueBridgeHandler = hueBridgeHandler;
    }

    public void activate() {
        this.hueBridgeHandler.registerLightStatusListener(this);
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime());
        this.hueBridgeHandler.unregisterLightStatusListener(this);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return HueLightHandler.SUPPORTED_THING_TYPES;
    }

    public void startScan() {
        List<FullLight> lights = this.hueBridgeHandler.getFullLights();
        for (FullLight l : lights) {
            this.onLightAddedInternal(l);
        }
        this.hueBridgeHandler.startSearch();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    @Override
    public void onLightAdded(@Nullable HueBridge bridge, FullLight light) {
        this.onLightAddedInternal(light);
    }

    private void onLightAddedInternal(FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        ThingTypeUID thingTypeUID = this.getThingTypeUID(light);
        String modelId = light.getModelID().replaceAll("[^a-zA-Z0-9_]", "_");
        if (thingUID != null && thingTypeUID != null) {
            ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("lightId", light.getId());
            properties.put("modelId", modelId);
            properties.put("uniqueId", light.getUniqueID());
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withThingType(thingTypeUID).withProperties(properties).withBridge(bridgeUID).withRepresentationProperty("uniqueId").withLabel(light.getName()).build();
            this.thingDiscovered(discoveryResult);
        } else {
            this.logger.debug("discovered unsupported light of type '{}' and model '{}' with id {}", new Object[]{light.getType(), modelId, light.getId()});
        }
    }

    @Override
    public void onLightRemoved(@Nullable HueBridge bridge, FullLight light) {
        ThingUID thingUID = this.getThingUID(light);
        if (thingUID != null) {
            this.thingRemoved(thingUID);
        }
    }

    @Override
    public void onLightStateChanged(@Nullable HueBridge bridge, FullLight light) {
    }

    private @Nullable ThingUID getThingUID(FullLight light) {
        ThingUID bridgeUID = this.hueBridgeHandler.getThing().getUID();
        ThingTypeUID thingTypeUID = this.getThingTypeUID(light);
        if (thingTypeUID != null && this.getSupportedThingTypes().contains(thingTypeUID)) {
            return new ThingUID(thingTypeUID, bridgeUID, light.getId());
        }
        return null;
    }

    private @Nullable ThingTypeUID getThingTypeUID(FullLight light) {
        String thingTypeId = TYPE_TO_ZIGBEE_ID_MAP.get(light.getType().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase());
        return thingTypeId != null ? new ThingTypeUID("hue", thingTypeId) : null;
    }
}

