/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightCommunicationHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightContext;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.listener.LifxPropertiesUpdateListener;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetHostFirmwareRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetVersionRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetWifiFirmwareRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Products;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateHostFirmwareResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateVersionResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateWifiFirmwareResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxLightPropertiesUpdater {
    private final Logger logger = LoggerFactory.getLogger(LifxLightPropertiesUpdater.class);
    private static final int UPDATE_INTERVAL = 15;
    private final String logId;
    private final InetSocketAddress ipAddress;
    private final MACAddress macAddress;
    private final LifxLightHandler.CurrentLightState currentLightState;
    private final LifxLightCommunicationHandler communicationHandler;
    private final List<LifxPropertiesUpdateListener> propertiesUpdateListeners = new CopyOnWriteArrayList<LifxPropertiesUpdateListener>();
    private final List<Packet> requestPackets = Arrays.asList(new GetVersionRequest(), new GetHostFirmwareRequest(), new GetWifiFirmwareRequest());
    private final Set<Integer> receivedPacketTypes = new HashSet<Integer>();
    private final ReentrantLock lock = new ReentrantLock();
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> updateJob;
    private final Map<String, String> properties = new HashMap<String, String>();
    private boolean updating;
    private boolean wasOnline;

    public LifxLightPropertiesUpdater(LifxLightContext context, LifxLightCommunicationHandler communicationHandler) {
        this.logId = context.getLogId();
        this.macAddress = context.getConfiguration().getMACAddress();
        this.ipAddress = context.getConfiguration().getHost();
        this.currentLightState = context.getCurrentLightState();
        this.scheduler = context.getScheduler();
        this.communicationHandler = communicationHandler;
    }

    public void updateProperties() {
        if (this.propertiesUpdateListeners.isEmpty()) {
            this.logger.debug("{} : Not updating properties because there are no listeners", (Object)this.logId);
            return;
        }
        try {
            try {
                this.lock.lock();
                boolean isOnline = this.currentLightState.isOnline();
                if (isOnline) {
                    if (!this.wasOnline) {
                        this.logger.debug("{} : Updating light properties", (Object)this.logId);
                        this.properties.clear();
                        this.receivedPacketTypes.clear();
                        this.updating = true;
                        this.updateHostProperty();
                        this.updateMACAddressProperty();
                        this.sendPropertyRequestPackets();
                    } else if (this.updating && !this.receivedAllResponsePackets()) {
                        this.logger.debug("{} : Resending requests for missing response packets", (Object)this.logId);
                        this.sendPropertyRequestPackets();
                    }
                }
                this.wasOnline = isOnline;
            }
            catch (Exception e) {
                this.logger.error("Error occurred while polling online state of a light ({})", (Object)this.logId, (Object)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateHostProperty() {
        if (this.communicationHandler.getIpAddress() != null) {
            this.properties.put("host", this.communicationHandler.getIpAddress().getHostString());
        } else if (this.ipAddress != null) {
            this.properties.put("host", this.ipAddress.getHostString());
        }
    }

    private void updateMACAddressProperty() {
        if (this.communicationHandler.getMACAddress() != null) {
            this.properties.put("macAddress", this.communicationHandler.getMACAddress().getAsLabel());
        } else if (this.macAddress != null) {
            this.properties.put("macAddress", this.macAddress.getAsLabel());
        }
    }

    private void sendPropertyRequestPackets() {
        for (Packet packet : this.requestPackets) {
            if (this.receivedPacketTypes.contains(packet.expectedResponses()[0])) continue;
            this.communicationHandler.sendPacket(packet);
        }
    }

    public void handleResponsePacket(Packet packet) {
        if (!this.updating) {
            return;
        }
        if (packet instanceof StateVersionResponse) {
            Products products = Products.getProductFromProductID(((StateVersionResponse)packet).getProduct());
            long productVersion = ((StateVersionResponse)packet).getVersion();
            this.properties.put("productId", Long.toString(products.getProduct()));
            this.properties.put("productName", products.getName());
            this.properties.put("productVersion", Long.toString(productVersion));
            this.properties.put("vendorId", Long.toString(products.getVendor()));
            this.properties.put("vendorName", products.getVendorName());
            this.receivedPacketTypes.add(packet.getPacketType());
        } else if (packet instanceof StateHostFirmwareResponse) {
            String hostVersion = ((StateHostFirmwareResponse)packet).getVersion().toString();
            this.properties.put("hostVersion", hostVersion);
            this.receivedPacketTypes.add(packet.getPacketType());
        } else if (packet instanceof StateWifiFirmwareResponse) {
            String wifiVersion = ((StateWifiFirmwareResponse)packet).getVersion().toString();
            this.properties.put("wifiVersion", wifiVersion);
            this.receivedPacketTypes.add(packet.getPacketType());
        }
        if (this.receivedAllResponsePackets()) {
            this.updating = false;
            this.propertiesUpdateListeners.forEach(listener -> listener.handlePropertiesUpdate(this.properties));
            this.logger.debug("{} : Finished updating light properties", (Object)this.logId);
        }
    }

    private boolean receivedAllResponsePackets() {
        return this.requestPackets.size() == this.receivedPacketTypes.size();
    }

    public void addPropertiesUpdateListener(LifxPropertiesUpdateListener listener) {
        this.propertiesUpdateListeners.add(listener);
    }

    public void removePropertiesUpdateListener(LifxPropertiesUpdateListener listener) {
        this.propertiesUpdateListeners.remove(listener);
    }

    public void start() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.addResponsePacketListener(this::handleResponsePacket);
                if (this.updateJob == null || this.updateJob.isCancelled()) {
                    this.updateJob = this.scheduler.scheduleWithFixedDelay(this::updateProperties, 0L, 15L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while starting properties update job for a light ({})", (Object)this.logId, (Object)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.removeResponsePacketListener(this::handleResponsePacket);
                if (this.updateJob != null && !this.updateJob.isCancelled()) {
                    this.updateJob.cancel(true);
                    this.updateJob = null;
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while stopping properties update job for a light ({})", (Object)this.logId, (Object)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

