/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import org.eclipse.smarthome.binding.lifx.internal.util.LifxMessageUtil;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.PercentType;

public class HSBK {
    private static final String DEFAULT_PROPERTY_NAME = "hsbk";
    private int hue;
    private int saturation;
    private int brightness;
    private int kelvin;

    public HSBK(int hue, int saturation, int brightness, int kelvin) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.kelvin = kelvin;
    }

    public HSBK(HSBK other) {
        this(other.hue, other.saturation, other.brightness, other.kelvin);
    }

    public HSBK(HSBType hsb, PercentType temperature) {
        this.setHSB(hsb);
        this.setTemperature(temperature);
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public int getKelvin() {
        return this.kelvin;
    }

    public HSBType getHSB() {
        DecimalType hue = LifxMessageUtil.hueToDecimalType(this.hue);
        PercentType saturation = LifxMessageUtil.saturationToPercentType(this.saturation);
        PercentType brightness = LifxMessageUtil.brightnessToPercentType(this.brightness);
        return new HSBType(hue, saturation, brightness);
    }

    public PercentType getTemperature() {
        return LifxMessageUtil.kelvinToPercentType(this.kelvin);
    }

    public void setHSB(HSBType hsb) {
        this.setHue(hsb.getHue());
        this.setSaturation(hsb.getSaturation());
        this.setBrightness(hsb.getBrightness());
    }

    public void setHue(DecimalType hue) {
        this.hue = LifxMessageUtil.decimalTypeToHue(hue);
    }

    public void setSaturation(PercentType saturation) {
        this.saturation = LifxMessageUtil.percentTypeToSaturation(saturation);
    }

    public void setBrightness(PercentType brightness) {
        this.brightness = LifxMessageUtil.percentTypeToBrightness(brightness);
    }

    public void setTemperature(PercentType temperature) {
        this.kelvin = LifxMessageUtil.percentTypeToKelvin(temperature);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.hue;
        result = 31 * result + this.saturation;
        result = 31 * result + this.brightness;
        result = 31 * result + this.kelvin;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSBK other = (HSBK)obj;
        if (this.hue != other.hue) {
            return false;
        }
        if (this.saturation != other.saturation) {
            return false;
        }
        if (this.brightness != other.brightness) {
            return false;
        }
        return this.kelvin == other.kelvin;
    }

    public String toString() {
        return this.toString(DEFAULT_PROPERTY_NAME);
    }

    public String toString(String propertyName) {
        return String.format("%s=%d,%d,%d,%d", propertyName, this.hue, this.saturation, this.brightness, this.kelvin);
    }
}

