/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt8Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class GetColorZonesRequest
extends Packet {
    public static final int TYPE = 502;
    public static final Field<Integer> FIELD_START_INDEX = new UInt8Field();
    public static final Field<Integer> FIELD_END_INDEX = new UInt8Field();
    private int startIndex = 0;
    private int endIndex = 255;

    public GetColorZonesRequest() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public GetColorZonesRequest(int index) {
        this(index, index);
    }

    public GetColorZonesRequest(int startIndex, int endIndex) {
        this();
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int packetType() {
        return 502;
    }

    @Override
    protected int packetLength() {
        return 2;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.startIndex = FIELD_START_INDEX.value(bytes);
        this.endIndex = FIELD_END_INDEX.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_START_INDEX.bytes(this.startIndex)).put(FIELD_END_INDEX.bytes(this.endIndex));
    }

    @Override
    public int[] expectedResponses() {
        return new int[]{506, 503};
    }
}

