/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

public enum Products {
    OR1000(1, 1, "Original 1000", true, false, false),
    C650(1, 3, "Color 650", true, false, false),
    W800LV(1, 10, "White 800 (Low Voltage)", false, false, false),
    W800HV(1, 11, "White 800 (High Voltage)", false, false, false),
    W900LV(1, 18, "White 900 BR30 (Low Voltage)", false, false, false),
    C1000BR30(1, 20, "Color 1000 BR30", true, false, false),
    C1000(1, 22, "Color 1000", true, false, false),
    LA19_1(1, 27, "LIFX A19", true, false, false),
    LBR30_1(1, 28, "LIFX BR30", true, false, false),
    LPA19_1(1, 29, "LIFX+ A19", true, true, false),
    LPBR30_1(1, 30, "LIFX+ BR30", true, true, false),
    LZ_1(1, 31, "LIFX Z", true, false, true),
    LZ_2(1, 32, "LIFX Z 2", true, false, true),
    LDL_1(1, 36, "LIFX Downlight", true, false, false),
    LDL_2(1, 37, "LIFX Downlight", true, false, false),
    LA19_2(1, 43, "LIFX A19", true, false, false),
    LBR30_2(1, 44, "LIFX BR30", true, false, false),
    LPA19_2(1, 45, "LIFX+ A19", true, true, false),
    LPBR30_2(1, 46, "LIFX+ BR30", true, true, false),
    LM(1, 49, "LIFX Mini", true, false, false),
    LMDD(1, 50, "LIFX Mini Day and Dusk", false, false, false),
    LMW(1, 51, "LIFX Mini White", false, false, false),
    LGU10(1, 52, "LIFX GU10", true, false, false);

    private final long vendorID;
    private final long productID;
    private final String name;
    private final boolean color;
    private boolean infrared;
    private boolean multiZone;

    private Products(int vendorID, int productID, String name, boolean color, boolean infrared, boolean multiZone) {
        this.vendorID = vendorID;
        this.productID = productID;
        this.name = name;
        this.color = color;
        this.infrared = infrared;
        this.multiZone = multiZone;
    }

    public String toString() {
        return this.name;
    }

    public long getVendor() {
        return this.vendorID;
    }

    public String getVendorName() {
        return this.vendorID == 1L ? "LIFX" : "Unknown";
    }

    public long getProduct() {
        return this.productID;
    }

    public String getName() {
        return this.name;
    }

    public ThingTypeUID getThingTypeUID() {
        if (this.isColor()) {
            if (this.isInfrared()) {
                return LifxBindingConstants.THING_TYPE_COLORIRLIGHT;
            }
            if (this.isMultiZone()) {
                return LifxBindingConstants.THING_TYPE_COLORMZLIGHT;
            }
            return LifxBindingConstants.THING_TYPE_COLORLIGHT;
        }
        return LifxBindingConstants.THING_TYPE_WHITELIGHT;
    }

    public boolean isColor() {
        return this.color;
    }

    public boolean isInfrared() {
        return this.infrared;
    }

    public boolean isMultiZone() {
        return this.multiZone;
    }

    public static Products getLikelyProduct(ThingTypeUID uid) throws IllegalArgumentException {
        Products[] productsArray = Products.values();
        int n = productsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Products product = productsArray[n2];
            if (product.getThingTypeUID().equals((Object)uid)) {
                return product;
            }
            ++n2;
        }
        throw new IllegalArgumentException(uid + " is not a valid product thing type UID");
    }

    public static Products getProductFromProductID(long id) throws IllegalArgumentException {
        Products[] productsArray = Products.values();
        int n = productsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Products product = productsArray[n2];
            if (product.productID == id) {
                return product;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is not a valid product ID");
    }
}

