/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.ByteField;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.FloatField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SignalStrength;

public class StateHostInfoResponse
extends Packet {
    public static final int TYPE = 13;
    public static final Field<Float> FIELD_SIGNAL = new FloatField().little();
    public static final Field<Long> FIELD_TX = new UInt32Field().little();
    public static final Field<Long> FIELD_RX = new UInt32Field().little();
    public static final Field<ByteBuffer> FIELD_RESERVED_5 = new ByteField(2);
    private float signal;
    private long tx;
    private long rx;

    public SignalStrength getSignalStrength() {
        return new SignalStrength(this.signal);
    }

    public long getTx() {
        return this.tx;
    }

    public long getRx() {
        return this.rx;
    }

    public StateHostInfoResponse() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 13;
    }

    @Override
    protected int packetLength() {
        return 14;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.signal = FIELD_SIGNAL.value(bytes).floatValue();
        this.tx = FIELD_TX.value(bytes);
        this.rx = FIELD_RX.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_SIGNAL.bytes(Float.valueOf(this.signal))).put(FIELD_TX.bytes(this.tx)).put(FIELD_RX.bytes(this.rx));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

