/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBKField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt8Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateMultiZoneResponse
extends Packet {
    public static final int TYPE = 506;
    public static final int ZONES = 8;
    public static final Field<Integer> FIELD_COUNT = new UInt8Field();
    public static final Field<Integer> FIELD_INDEX = new UInt8Field();
    public static final HSBKField FIELD_COLOR = new HSBKField();
    private int count;
    private int index;
    private HSBK[] colors = new HSBK[8];

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("count=");
        sb.append(this.count);
        sb.append(", index=");
        sb.append(this.index);
        int i = 0;
        while (i < 8) {
            sb.append(", ");
            sb.append(this.colors[i].toString("color[" + i + "]"));
            ++i;
        }
        return sb.toString();
    }

    public int getCount() {
        return this.count;
    }

    public int getIndex() {
        return this.index;
    }

    public HSBK[] getColors() {
        return this.colors;
    }

    @Override
    public int packetType() {
        return 506;
    }

    @Override
    protected int packetLength() {
        return 66;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.count = FIELD_COUNT.value(bytes);
        this.index = FIELD_INDEX.value(bytes);
        int i = 0;
        while (i < 8) {
            this.colors[i] = FIELD_COLOR.value(bytes);
            ++i;
        }
    }

    @Override
    protected ByteBuffer packetBytes() {
        ByteBuffer bb = ByteBuffer.allocate(this.packetLength()).put(FIELD_COUNT.bytes(this.count)).put(FIELD_INDEX.bytes(this.index));
        int i = 0;
        while (i < 8) {
            bb.put(FIELD_COLOR.bytes(this.colors[i]));
            ++i;
        }
        return bb;
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

