/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.PercentType;

@NonNullByDefault
public final class LifxMessageUtil {
    private static final BigDecimal INCREASE_DECREASE_STEP = new BigDecimal(10);
    private static final BigDecimal ZERO = PercentType.ZERO.toBigDecimal();
    private static final BigDecimal HUNDRED = PercentType.HUNDRED.toBigDecimal();

    private LifxMessageUtil() {
    }

    public static PercentType increaseDecreasePercentType(IncreaseDecreaseType increaseDecreaseType, PercentType old) {
        BigDecimal delta = ZERO;
        if (increaseDecreaseType == IncreaseDecreaseType.INCREASE) {
            delta = INCREASE_DECREASE_STEP;
        } else if (increaseDecreaseType == IncreaseDecreaseType.DECREASE) {
            delta = INCREASE_DECREASE_STEP.negate();
        }
        if (!ZERO.equals(delta)) {
            BigDecimal newValue = old.toBigDecimal().add(delta);
            newValue = newValue.setScale(0, RoundingMode.HALF_UP);
            newValue = newValue.min(HUNDRED);
            newValue = newValue.max(ZERO);
            return new PercentType(newValue);
        }
        return old;
    }

    private static PercentType intToPercentType(int i) {
        return new PercentType(Math.round((float)i / 65535.0f * 100.0f));
    }

    private static int percentTypeToInt(PercentType percentType) {
        return (int)(percentType.floatValue() / 100.0f * 65535.0f);
    }

    public static DecimalType hueToDecimalType(int hue) {
        return new DecimalType((double)((float)(hue * 360) / 65535.0f));
    }

    public static int decimalTypeToHue(DecimalType hue) {
        return (int)(hue.floatValue() / 360.0f * 65535.0f);
    }

    public static PercentType saturationToPercentType(int saturation) {
        return LifxMessageUtil.intToPercentType(saturation);
    }

    public static int percentTypeToSaturation(PercentType saturation) {
        return LifxMessageUtil.percentTypeToInt(saturation);
    }

    public static PercentType brightnessToPercentType(int brightness) {
        return LifxMessageUtil.intToPercentType(brightness);
    }

    public static int percentTypeToBrightness(PercentType brightness) {
        return LifxMessageUtil.percentTypeToInt(brightness);
    }

    public static PercentType kelvinToPercentType(int kelvin) {
        return new PercentType((kelvin - 9000) / -65);
    }

    public static int percentTypeToKelvin(PercentType temperature) {
        return 9000 - temperature.intValue() * 65;
    }

    public static PercentType infraredToPercentType(int infrared) {
        return LifxMessageUtil.intToPercentType(infrared);
    }

    public static int percentTypeToInfrared(PercentType infrared) {
        return LifxMessageUtil.percentTypeToInt(infrared);
    }

    public static boolean sameColors(HSBK ... colors) {
        if (colors.length <= 1) {
            return true;
        }
        int i = 1;
        while (i < colors.length) {
            if (!colors[0].equals(colors[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static long randomSourceId() {
        return UUID.randomUUID().getLeastSignificantBits() & 0xFFFFFFFFL;
    }
}

