/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.binding.lirc.handler.LIRCBridgeHandler;
import org.eclipse.smarthome.binding.lirc.internal.LIRCMessageListener;
import org.eclipse.smarthome.binding.lirc.internal.config.LIRCRemoteConfiguration;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCButtonEvent;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCResponse;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIRCRemoteHandler
extends BaseThingHandler
implements LIRCMessageListener {
    private final Logger logger = LoggerFactory.getLogger(LIRCRemoteHandler.class);
    private static final Pattern UNKNOWN_REMOTE_PATTERN = Pattern.compile("^unknown remote: \"(.+)\"$");
    private LIRCBridgeHandler bridgeHandler;
    private LIRCRemoteConfiguration config;
    private String remoteName = null;

    public LIRCRemoteHandler(Thing thing) {
        super(thing);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.debug("Received channel: {}, command: {}", (Object)channelUID, (Object)command);
        if (this.remoteName == null) {
            this.logger.error("Remote name is not set in {}", (Object)this.getThing().getUID());
            return;
        }
        if (channelUID.getId().equals("transmit") && !(command instanceof RefreshType) && command instanceof StringType) {
            this.bridgeHandler.transmit(this.remoteName, command.toString());
        }
    }

    public void initialize() {
        this.logger.debug("Initializing thing {}", (Object)this.getThing().getUID());
        this.config = (LIRCRemoteConfiguration)this.getConfigAs(LIRCRemoteConfiguration.class);
        this.remoteName = this.config.getRemote();
        if (this.remoteName == null) {
            this.logger.error("Remote name is not set in {}", (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Remote name is not set");
        } else {
            this.bridgeHandler = (LIRCBridgeHandler)this.getBridge().getHandler();
            this.bridgeHandler.registerMessageListener(this);
            if (this.getBridge().getStatus() == ThingStatus.ONLINE) {
                this.updateStatus(ThingStatus.ONLINE);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
            }
        }
    }

    public void dispose() {
        this.logger.debug("Thing {} disposed.", (Object)this.getThing().getUID());
        if (this.bridgeHandler != null) {
            this.bridgeHandler.unregisterMessageListener(this);
        }
        this.bridgeHandler = null;
        super.dispose();
    }

    @Override
    public void onButtonPressed(ThingUID bridge, LIRCButtonEvent buttonEvent) {
        if (this.remoteName.equals(buttonEvent.getRemote())) {
            this.logger.debug("Remote {}: Button {} pressed {} times.", new Object[]{this.remoteName, buttonEvent.getButton(), buttonEvent.getRepeats() + 1});
            this.updateStatus(ThingStatus.ONLINE);
            this.triggerChannel("event", buttonEvent.getButton());
        }
    }

    @Override
    public void onMessageReceived(ThingUID bridge, LIRCResponse response) {
        String error;
        Matcher m;
        String command = response.getCommand();
        if ("LIST".equals(command) && response.isSuccess()) {
            boolean found = false;
            String[] stringArray = response.getData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String remote = stringArray[n2];
                if (this.remoteName.equals(remote)) {
                    found = true;
                }
                ++n2;
            }
            if (found) {
                this.updateStatus(ThingStatus.ONLINE);
            } else {
                this.logger.error("Remote {}: Remote was removed from LIRC server.", (Object)this.remoteName);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            }
        } else if (!response.isSuccess() && (m = UNKNOWN_REMOTE_PATTERN.matcher(error = response.getData()[0])).matches() && this.remoteName.equals(m.group(1))) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Unknown remote");
        }
    }
}

