/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.binding.sonos.internal.SonosAudioSink;
import org.eclipse.smarthome.binding.sonos.internal.SonosBindingConstants;
import org.eclipse.smarthome.binding.sonos.internal.handler.ZonePlayerHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.audio.AudioHTTPServer;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.net.HttpServiceUtil;
import org.eclipse.smarthome.core.net.NetworkAddressService;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ThingHandlerFactory.class}, immediate=true, configurationPid="binding.sonos", configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class SonosHandlerFactory
extends BaseThingHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(SonosHandlerFactory.class);
    private UpnpIOService upnpIOService;
    private AudioHTTPServer audioHTTPServer;
    private NetworkAddressService networkAddressService;
    private final Map<String, ServiceRegistration<AudioSink>> audioSinkRegistrations = new ConcurrentHashMap<String, ServiceRegistration<AudioSink>>();
    private String opmlUrl = null;
    private String callbackUrl = null;

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        Dictionary properties = componentContext.getProperties();
        this.opmlUrl = (String)properties.get("opmlUrl");
        this.callbackUrl = (String)properties.get("callbackUrl");
    }

    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        if (SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID)) {
            ThingUID sonosDeviceUID = this.getPlayerUID(thingTypeUID, thingUID, configuration);
            this.logger.debug("Creating a sonos thing with ID '{}'", (Object)sonosDeviceUID);
            return super.createThing(thingTypeUID, configuration, sonosDeviceUID, null);
        }
        throw new IllegalArgumentException("The thing type " + thingTypeUID + " is not supported by the sonos binding.");
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID)) {
            this.logger.debug("Creating a ZonePlayerHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
            ZonePlayerHandler handler = new ZonePlayerHandler(thing, this.upnpIOService, this.opmlUrl);
            String callbackUrl = this.createCallbackUrl();
            SonosAudioSink audioSink = new SonosAudioSink(handler, this.audioHTTPServer, callbackUrl);
            ServiceRegistration reg = this.getBundleContext().registerService(AudioSink.class.getName(), (Object)audioSink, new Hashtable());
            this.audioSinkRegistrations.put(thing.getUID().toString(), (ServiceRegistration<AudioSink>)reg);
            return handler;
        }
        return null;
    }

    private String createCallbackUrl() {
        if (this.callbackUrl != null) {
            return this.callbackUrl;
        }
        String ipAddress = this.networkAddressService.getPrimaryIpv4HostAddress();
        if (ipAddress == null) {
            this.logger.warn("No network interface could be found.");
            return null;
        }
        int port = HttpServiceUtil.getHttpServicePort((BundleContext)this.bundleContext);
        if (port == -1) {
            this.logger.warn("Cannot find port of the http service.");
            return null;
        }
        return "http://" + ipAddress + ":" + port;
    }

    public void unregisterHandler(Thing thing) {
        super.unregisterHandler(thing);
        ServiceRegistration<AudioSink> reg = this.audioSinkRegistrations.get(thing.getUID().toString());
        if (reg != null) {
            reg.unregister();
        }
    }

    private ThingUID getPlayerUID(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration) {
        if (thingUID != null) {
            return thingUID;
        }
        String udn = (String)configuration.get("udn");
        return new ThingUID(thingTypeUID, udn);
    }

    @Reference
    protected void setUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = upnpIOService;
    }

    protected void unsetUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = null;
    }

    @Reference
    protected void setAudioHTTPServer(AudioHTTPServer audioHTTPServer) {
        this.audioHTTPServer = audioHTTPServer;
    }

    protected void unsetAudioHTTPServer(AudioHTTPServer audioHTTPServer) {
        this.audioHTTPServer = null;
    }

    @Reference
    protected void setNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = networkAddressService;
    }

    protected void unsetNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = null;
    }
}

