/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.handler;

import com.google.gson.JsonElement;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriThingHandler;
import org.eclipse.smarthome.binding.tradfri.internal.model.TradfriSensorData;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriSensorHandler
extends TradfriThingHandler {
    private final Logger logger = LoggerFactory.getLogger(TradfriSensorHandler.class);
    private TradfriSensorData state;

    public TradfriSensorHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void onUpdate(JsonElement data) {
        if (this.active && !data.isJsonNull()) {
            OnOffType batteryLow;
            this.state = new TradfriSensorData(data);
            this.updateStatus(this.state.getReachabilityStatus() ? ThingStatus.ONLINE : ThingStatus.OFFLINE);
            DecimalType batteryLevel = this.state.getBatteryLevel();
            if (batteryLevel != null) {
                this.updateState("battery_level", (State)batteryLevel);
            }
            if ((batteryLow = this.state.getBatteryLow()) != null) {
                this.updateState("battery_low", (State)batteryLow);
            }
            this.updateDeviceProperties(this.state);
            this.logger.debug("Updating thing for sensorId {} to state {batteryLevel: {}, batteryLow: {}, firmwareVersion: {}, modelId: {}, vendor: {}}", new Object[]{this.state.getDeviceId(), batteryLevel, batteryLow, this.state.getFirmwareVersion(), this.state.getModelId(), this.state.getVendor()});
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.logger.debug("Refreshing channel {}", (Object)channelUID);
            this.coapClient.asyncGet(this);
            return;
        }
        this.logger.debug("The sensor is a read-only device and cannot handle commands.");
    }
}

