/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.concurrent.CompletableFuture;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.smarthome.binding.tradfri.internal.CoapCallback;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriCoapHandler
implements CoapHandler {
    private final Logger logger = LoggerFactory.getLogger(TradfriCoapHandler.class);
    private final JsonParser parser = new JsonParser();
    private CoapCallback callback;
    private CompletableFuture<String> future;

    public TradfriCoapHandler(CoapCallback callback) {
        this.callback = callback;
    }

    public TradfriCoapHandler(CompletableFuture<String> future) {
        this.future = future;
    }

    public void onLoad(CoapResponse response) {
        this.logger.debug("CoAP response\noptions: {}\npayload: {} ", (Object)response.getOptions(), (Object)response.getResponseText());
        if (response.isSuccess()) {
            if (this.callback != null) {
                try {
                    this.callback.onUpdate(this.parser.parse(response.getResponseText()));
                    this.callback.setStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
                }
                catch (JsonParseException e) {
                    this.logger.warn("Observed value is no valid json: {}, {}", (Object)response.getResponseText(), (Object)e.getMessage());
                }
            }
            if (this.future != null) {
                String data = response.getResponseText();
                this.future.complete(data);
            }
        } else {
            this.logger.debug("CoAP error {}", (Object)response.getCode());
            if (this.callback != null) {
                this.callback.setStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            }
            if (this.future != null) {
                this.future.completeExceptionally(new RuntimeException("Response " + response.getCode().toString()));
            }
        }
    }

    public void onError() {
        this.logger.debug("CoAP onError");
        if (this.callback != null) {
            this.callback.setStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
        }
        if (this.future != null) {
            this.future.completeExceptionally(new RuntimeException("CoAP GET resulted in an error."));
        }
    }
}

