/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.json;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonUtils;

public class WeatherUndergroundJsonCurrent {
    private Location observation_location;
    private String station_id;
    private String observation_epoch;
    private String weather;
    private BigDecimal temp_f;
    private BigDecimal temp_c;
    private String relative_humidity;
    private String wind_dir;
    private BigDecimal wind_degrees;
    private BigDecimal wind_mph;
    private String wind_gust_mph;
    private BigDecimal wind_kph;
    private String wind_gust_kph;
    private String pressure_mb;
    private String pressure_in;
    private BigDecimal dewpoint_f;
    private BigDecimal dewpoint_c;
    private String heat_index_f;
    private String heat_index_c;
    private String windchill_f;
    private String windchill_c;
    private String feelslike_f;
    private String feelslike_c;
    private String visibility_mi;
    private String visibility_km;
    private String solarradiation;
    private String UV;
    private String precip_1hr_in;
    private String precip_1hr_metric;
    private String precip_today_in;
    private String precip_today_metric;
    private String icon_url;

    public String getLocation() {
        return this.observation_location == null ? null : this.observation_location.getFull();
    }

    public String getStationId() {
        return this.station_id;
    }

    public Calendar getObservationTime() {
        return WeatherUndergroundJsonUtils.convertToCalendar(this.observation_epoch);
    }

    public String getConditions() {
        return this.weather;
    }

    public BigDecimal getTemperatureC() {
        return this.temp_c;
    }

    public BigDecimal getTemperatureF() {
        return this.temp_f;
    }

    public Integer getRelativeHumidity() {
        if (this.relative_humidity != null && !this.relative_humidity.isEmpty() && !this.relative_humidity.equalsIgnoreCase("N/A")) {
            return WeatherUndergroundJsonUtils.convertToInteger(this.relative_humidity.replace("%", ""));
        }
        return null;
    }

    public String getWindDirection() {
        return this.wind_dir;
    }

    public BigDecimal getWindDirectionDegrees() {
        return this.wind_degrees;
    }

    public BigDecimal getWindSpeedKmh() {
        return this.wind_kph;
    }

    public BigDecimal getWindSpeedMph() {
        return this.wind_mph;
    }

    public BigDecimal getWindGustKmh() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.wind_gust_kph);
    }

    public BigDecimal getWindGustMph() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.wind_gust_mph);
    }

    public BigDecimal getPressureHPa() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.pressure_mb);
    }

    public BigDecimal getPressureInHg() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.pressure_in);
    }

    public BigDecimal getDewPointC() {
        return this.dewpoint_c;
    }

    public BigDecimal getDewPointF() {
        return this.dewpoint_f;
    }

    public BigDecimal getHeatIndexC() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.heat_index_c);
    }

    public BigDecimal getHeatIndexF() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.heat_index_f);
    }

    public BigDecimal getWindChillC() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.windchill_c);
    }

    public BigDecimal getWindChillF() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.windchill_f);
    }

    public BigDecimal getFeelingTemperatureC() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.feelslike_c);
    }

    public BigDecimal getFeelingTemperatureF() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.feelslike_f);
    }

    public BigDecimal getVisibilityKm() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.visibility_km);
    }

    public BigDecimal getVisibilityMi() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.visibility_mi);
    }

    public BigDecimal getPrecipitationHourMm() {
        BigDecimal result = WeatherUndergroundJsonUtils.convertToBigDecimal(this.precip_1hr_metric);
        if (result != null && result.doubleValue() < 0.0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public BigDecimal getPrecipitationHourIn() {
        BigDecimal result = WeatherUndergroundJsonUtils.convertToBigDecimal(this.precip_1hr_in);
        if (result != null && result.doubleValue() < 0.0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public BigDecimal getPrecipitationDayMm() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.precip_today_metric);
    }

    public BigDecimal getPrecipitationDayIn() {
        return WeatherUndergroundJsonUtils.convertToBigDecimal(this.precip_today_in);
    }

    public BigDecimal getSolarRadiation() {
        BigDecimal value = WeatherUndergroundJsonUtils.convertToBigDecimal(this.solarradiation);
        if (value != null && value.signum() == -1) {
            value = null;
        }
        return value;
    }

    public BigDecimal getUVIndex() {
        BigDecimal value = WeatherUndergroundJsonUtils.convertToBigDecimal(this.UV);
        if (value != null && value.signum() == -1) {
            value = null;
        }
        return value;
    }

    public URL getIcon() {
        return WeatherUndergroundJsonUtils.getValidUrl(this.icon_url);
    }

    class Location {
        private String full;
        private String city;
        private String state;
        private String state_name;
        private String country;
        private String country_iso3166;
        private String zip;
        private String magic;
        private String wmo;
        private String latitude;
        private String longitude;
        private String elevation;

        Location() {
        }

        public String getFull() {
            return this.full;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getState_name() {
            return this.state_name;
        }

        public String getCountry() {
            return this.country;
        }

        public String getCountry_iso3166() {
            return this.country_iso3166;
        }

        public String getZip() {
            return this.zip;
        }

        public String getMagic() {
            return this.magic;
        }

        public String getWmo() {
            return this.wmo;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public String getElevation() {
            return this.elevation;
        }
    }
}

