/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.handler;

import java.util.Collections;
import java.util.Set;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WemoBridgeHandler
extends BaseBridgeHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WemoBindingConstants.THING_TYPE_BRIDGE);
    private Logger logger = LoggerFactory.getLogger(WemoBridgeHandler.class);

    public WemoBridgeHandler(Bridge bridge) {
        super(bridge);
        this.logger.debug("Creating a WemoBridgeHandler for thing '{}'", (Object)this.getThing().getUID());
    }

    public void initialize() {
        this.logger.debug("Initializing WemoBridgeHandler");
        Configuration configuration = this.getConfig();
        if (configuration.get("udn") != null) {
            this.logger.trace("Initializing WemoBridgeHandler for UDN '{}'", configuration.get("udn"));
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.logger.debug("Cannot initalize WemoBridgeHandler. UDN not set.");
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }
}

