/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.yahooweather.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.yahooweather.internal.connection.YahooWeatherConnection;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;
import org.eclipse.smarthome.core.cache.ExpiringCacheMap;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.ConfigStatusThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherHandler
extends ConfigStatusThingHandler {
    private static final String LOCATION_PARAM = "location";
    private final Logger logger = LoggerFactory.getLogger(YahooWeatherHandler.class);
    private static final int MAX_DATA_AGE = 10800000;
    private static final int CACHE_EXPIRY = 10000;
    private static final String CACHE_KEY_CONFIG = "CONFIG_STATUS";
    private static final String CACHE_KEY_WEATHER = "WEATHER";
    private final ExpiringCacheMap<String, String> cache = new ExpiringCacheMap(10000L);
    private final YahooWeatherConnection connection = new YahooWeatherConnection();
    private long lastUpdateTime;
    private BigDecimal location;
    private BigDecimal refresh;
    private String weatherData = null;
    ScheduledFuture<?> refreshJob;

    public YahooWeatherHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.logger.debug("Initializing YahooWeather handler.");
        Configuration config = this.getThing().getConfiguration();
        this.location = (BigDecimal)config.get(LOCATION_PARAM);
        try {
            this.refresh = (BigDecimal)config.get("refresh");
        }
        catch (Exception e) {
            this.logger.debug("Cannot set refresh parameter.", (Throwable)e);
        }
        if (this.refresh == null) {
            this.refresh = new BigDecimal(60);
        }
        this.cache.put((Object)CACHE_KEY_CONFIG, () -> this.connection.getResponseFromQuery("SELECT location FROM weather.forecast WHERE woeid = " + this.location.toPlainString()));
        this.cache.put((Object)CACHE_KEY_WEATHER, () -> this.connection.getResponseFromQuery("SELECT * FROM weather.forecast WHERE u = 'c' AND woeid = " + this.location.toPlainString()));
        this.startAutomaticRefresh();
    }

    public void dispose() {
        this.refreshJob.cancel(true);
    }

    private void startAutomaticRefresh() {
        this.refreshJob = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                boolean success = this.updateWeatherData();
                if (success) {
                    this.updateState(new ChannelUID(this.getThing().getUID(), "temperature"), this.getTemperature());
                    this.updateState(new ChannelUID(this.getThing().getUID(), "humidity"), this.getHumidity());
                    this.updateState(new ChannelUID(this.getThing().getUID(), "pressure"), this.getPressure());
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, e.getMessage());
            }
        }, 0L, this.refresh.intValue(), TimeUnit.SECONDS);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block14: {
            block13: {
                if (!(command instanceof RefreshType)) break block13;
                boolean success = this.updateWeatherData();
                if (!success) break block14;
                switch (channelUID.getId()) {
                    case "temperature": {
                        this.updateState(channelUID, this.getTemperature());
                        break;
                    }
                    case "humidity": {
                        this.updateState(channelUID, this.getHumidity());
                        break;
                    }
                    case "pressure": {
                        this.updateState(channelUID, this.getPressure());
                        break;
                    }
                    default: {
                        this.logger.debug("Command received for an unknown channel: {}", (Object)channelUID.getId());
                        break;
                    }
                }
                break block14;
            }
            this.logger.debug("Command {} is not supported for channel: {}", (Object)command, (Object)channelUID.getId());
        }
    }

    public Collection<ConfigStatusMessage> getConfigStatus() {
        String city;
        ArrayList<ConfigStatusMessage> configStatus = new ArrayList<ConfigStatusMessage>();
        String locationData = (String)this.cache.get((Object)CACHE_KEY_CONFIG);
        if (locationData != null && (city = this.getValue(locationData, LOCATION_PARAM, "city")) == null) {
            configStatus.add(ConfigStatusMessage.Builder.error((String)LOCATION_PARAM).withMessageKeySuffix("location-not-found").withArguments(new Object[]{this.location.toPlainString()}).build());
        }
        return configStatus;
    }

    private synchronized boolean updateWeatherData() {
        String data = (String)this.cache.get((Object)CACHE_KEY_WEATHER);
        if (data != null) {
            if (data.contains("\"results\":null")) {
                if (this.isCurrentDataExpired()) {
                    this.logger.trace("The Yahoo Weather API did not return any data. Omiting the old result because it became too old.");
                    this.weatherData = null;
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "@text/offline.no-data");
                    return false;
                }
                this.logger.trace("The Yahoo Weather API did not return any data. Keeping the old result.");
                return false;
            }
            this.lastUpdateTime = System.currentTimeMillis();
            this.weatherData = data;
            this.updateStatus(ThingStatus.ONLINE);
            return true;
        }
        this.weatherData = null;
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "@text/offline.location [\"" + this.location.toPlainString() + "\"");
        return false;
    }

    private boolean isCurrentDataExpired() {
        return this.lastUpdateTime + 10800000L < System.currentTimeMillis();
    }

    private State getHumidity() {
        String humidity;
        if (this.weatherData != null && (humidity = this.getValue(this.weatherData, "atmosphere", "humidity")) != null) {
            return new DecimalType(humidity);
        }
        return UnDefType.UNDEF;
    }

    private State getPressure() {
        String pressure;
        if (this.weatherData != null && (pressure = this.getValue(this.weatherData, "atmosphere", "pressure")) != null) {
            DecimalType ret = new DecimalType(pressure);
            if (ret.doubleValue() > 10000.0) {
                ret = new DecimalType(BigDecimal.valueOf((long)(ret.doubleValue() / 0.3386388158), 2));
            }
            return ret;
        }
        return UnDefType.UNDEF;
    }

    private State getTemperature() {
        String temp;
        if (this.weatherData != null && (temp = this.getValue(this.weatherData, "condition", "temp")) != null) {
            return new DecimalType(temp);
        }
        return UnDefType.UNDEF;
    }

    private String getValue(String data, String element, String param) {
        String tmp = StringUtils.substringAfter((String)data, (String)element);
        if (tmp != null) {
            return StringUtils.substringBetween((String)tmp, (String)(String.valueOf(param) + "\":\""), (String)"\"");
        }
        return null;
    }
}

