/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.osgi.framework.Bundle;

public abstract class AbstractXmlBasedProvider<T_ID, T_OBJECT extends Identifiable<T_ID>> {
    private final Map<Bundle, List<T_OBJECT>> bundleObjectMap = new ConcurrentHashMap<Bundle, List<T_OBJECT>>();
    private final Map<LocalizedKey, T_OBJECT> localizedObjectCache = new ConcurrentHashMap<LocalizedKey, T_OBJECT>();

    protected abstract T_OBJECT localize(Bundle var1, T_OBJECT var2, Locale var3);

    public final synchronized void add(Bundle bundle, T_OBJECT object) {
        this.addAll(bundle, Collections.singletonList(object));
    }

    public final synchronized void addAll(Bundle bundle, Collection<T_OBJECT> objectList) {
        if (objectList == null || objectList.isEmpty()) {
            return;
        }
        List<T_OBJECT> objects = this.acquireObjects(bundle);
        if (objects == null) {
            return;
        }
        objects.addAll(objectList);
        for (Identifiable object : objectList) {
            this.removeCachedEntries(object);
        }
    }

    private List<T_OBJECT> acquireObjects(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        List<T_OBJECT> objects = this.bundleObjectMap.get(bundle);
        if (objects == null) {
            objects = new CopyOnWriteArrayList<T_OBJECT>();
            this.bundleObjectMap.put(bundle, objects);
        }
        return objects;
    }

    protected final T_OBJECT get(T_ID key, Locale locale) {
        for (Map.Entry<Bundle, List<T_OBJECT>> objects : this.bundleObjectMap.entrySet()) {
            for (Identifiable object : objects.getValue()) {
                if (!key.equals(object.getUID())) continue;
                return (T_OBJECT)this.acquireLocalizedObject(objects.getKey(), object, locale);
            }
        }
        return null;
    }

    protected final synchronized Collection<T_OBJECT> getAll(Locale locale) {
        LinkedList<Identifiable> ret = new LinkedList<Identifiable>();
        Set<Map.Entry<Bundle, List<T_OBJECT>>> objectList = this.bundleObjectMap.entrySet();
        for (Map.Entry entry : objectList) {
            for (Identifiable object : (List)entry.getValue()) {
                ret.add(this.acquireLocalizedObject((Bundle)entry.getKey(), object, locale));
            }
        }
        return ret;
    }

    public final synchronized void removeAll(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        List<T_OBJECT> objects = this.bundleObjectMap.remove(bundle);
        if (objects != null) {
            this.removeCachedEntries((T_OBJECT)objects);
        }
    }

    private void removeCachedEntries(List<T_OBJECT> objects) {
        for (Identifiable object : objects) {
            this.removeCachedEntries(object);
        }
    }

    private void removeCachedEntries(T_OBJECT object) {
        Iterator<Map.Entry<LocalizedKey, T_OBJECT>> it = this.localizedObjectCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<LocalizedKey, T_OBJECT> entry = it.next();
            if (!entry.getKey().id.equals(object.getUID())) continue;
            it.remove();
        }
    }

    private T_OBJECT acquireLocalizedObject(Bundle bundle, T_OBJECT object, Locale locale) {
        LocalizedKey localizedKey = this.getLocalizedKey(object, locale);
        Identifiable cacheEntry = (Identifiable)this.localizedObjectCache.get(localizedKey);
        if (cacheEntry != null) {
            return (T_OBJECT)cacheEntry;
        }
        T_OBJECT localizedObject = this.localize(bundle, object, locale);
        if (localizedObject != null) {
            this.localizedObjectCache.put(localizedKey, localizedObject);
            return localizedObject;
        }
        return object;
    }

    private LocalizedKey getLocalizedKey(T_OBJECT object, Locale locale) {
        return new LocalizedKey(object.getUID(), locale != null ? locale.toLanguageTag() : null);
    }

    private static class LocalizedKey {
        public final Object id;
        public final String locale;

        public LocalizedKey(Object id, String locale) {
            this.id = id;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalizedKey other = (LocalizedKey)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return Objects.equals(this.locale, other.locale);
        }
    }
}

