/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.FixedLengthAudioStream;
import org.eclipse.smarthome.core.audio.utils.AudioStreamUtils;

public class FileAudioStream
extends FixedLengthAudioStream {
    public static final String WAV_EXTENSION = "wav";
    public static final String MP3_EXTENSION = "mp3";
    public static final String OGG_EXTENSION = "ogg";
    public static final String AAC_EXTENSION = "aac";
    private File file;
    private AudioFormat audioFormat;
    private InputStream inputStream;
    private long length;

    public FileAudioStream(File file) throws AudioException {
        this(file, FileAudioStream.getAudioFormat(file));
    }

    public FileAudioStream(File file, AudioFormat format) throws AudioException {
        this.file = file;
        this.inputStream = FileAudioStream.getInputStream(file);
        this.audioFormat = format;
        this.length = file.length();
    }

    private static AudioFormat getAudioFormat(File file) throws AudioException {
        String extension;
        String filename = file.getName().toLowerCase();
        switch (extension = AudioStreamUtils.getExtension(filename)) {
            case "wav": {
                return new AudioFormat("WAVE", "PCM_SIGNED", false, 16, 705600, 44100L);
            }
            case "mp3": {
                return AudioFormat.MP3;
            }
            case "ogg": {
                return AudioFormat.OGG;
            }
            case "aac": {
                return AudioFormat.AAC;
            }
        }
        throw new AudioException("Unsupported file extension!");
    }

    private static InputStream getInputStream(File file) throws AudioException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new AudioException("File '" + file.getName() + "' not found!");
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        super.close();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public synchronized void reset() throws IOException {
        IOUtils.closeQuietly((InputStream)this.inputStream);
        try {
            this.inputStream = FileAudioStream.getInputStream(this.file);
        }
        catch (AudioException e) {
            throw new IOException("Cannot reset file input stream: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream getClonedStream() throws AudioException {
        return FileAudioStream.getInputStream(this.file);
    }
}

