/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioHTTPServer;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.FixedLengthAudioStream;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioServlet
extends HttpServlet
implements AudioHTTPServer {
    private static final long serialVersionUID = -3364664035854567854L;
    private static final String SERVLET_NAME = "/audio";
    private final Logger logger = LoggerFactory.getLogger(AudioServlet.class);
    private Map<String, AudioStream> oneTimeStreams = new ConcurrentHashMap<String, AudioStream>();
    private Map<String, FixedLengthAudioStream> multiTimeStreams = new ConcurrentHashMap<String, FixedLengthAudioStream>();
    private Map<String, Long> streamTimeouts = new ConcurrentHashMap<String, Long>();
    protected HttpService httpService;

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
        try {
            this.logger.debug("Starting up the audio servlet at /audio");
            Hashtable props = new Hashtable();
            httpService.registerServlet(SERVLET_NAME, (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void unsetHttpService(HttpService httpService) {
        httpService.unregister(SERVLET_NAME);
        this.httpService = null;
    }

    protected HttpContext createHttpContext() {
        HttpContext httpContext = this.httpService.createDefaultHttpContext();
        return httpContext;
    }

    private InputStream prepareInputStream(String streamId, HttpServletResponse resp) throws AudioException {
        Long size;
        boolean multiAccess;
        AudioStream stream;
        if (this.oneTimeStreams.containsKey(streamId)) {
            stream = this.oneTimeStreams.remove(streamId);
            multiAccess = false;
        } else if (this.multiTimeStreams.containsKey(streamId)) {
            stream = this.multiTimeStreams.get(streamId);
            multiAccess = true;
        } else {
            return null;
        }
        this.logger.debug("Stream to serve is {}", (Object)streamId);
        String mimeType = stream.getFormat().getCodec() == "MP3" ? "audio/mpeg" : (stream.getFormat().getContainer() == "WAVE" ? "audio/wav" : (stream.getFormat().getContainer() == "OGG" ? "audio/ogg" : null));
        if (mimeType != null) {
            resp.setContentType(mimeType);
        }
        if (stream instanceof FixedLengthAudioStream && (size = Long.valueOf(((FixedLengthAudioStream)stream).length())) != null) {
            resp.setContentLength(size.intValue());
        }
        if (multiAccess) {
            return ((FixedLengthAudioStream)stream).getClonedStream();
        }
        return stream;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.removeTimedOutStreams();
        String streamId = StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)req.getRequestURI(), (String)"/"), (String)".");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream stream = this.prepareInputStream(streamId, resp);){
                if (stream == null) {
                    this.logger.debug("Received request for invalid stream id at {}", (Object)req.getRequestURI());
                    resp.sendError(404);
                } else {
                    IOUtils.copy((InputStream)stream, (OutputStream)resp.getOutputStream());
                    resp.flushBuffer();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AudioException ex) {
            resp.sendError(500, ex.getMessage());
        }
    }

    private synchronized void removeTimedOutStreams() {
        for (String streamId : this.multiTimeStreams.keySet()) {
            if (this.streamTimeouts.get(streamId) >= System.nanoTime()) continue;
            FixedLengthAudioStream stream = this.multiTimeStreams.remove(streamId);
            this.streamTimeouts.remove(streamId);
            IOUtils.closeQuietly((InputStream)stream);
            stream = null;
            this.logger.debug("Removed timed out stream {}", (Object)streamId);
        }
    }

    @Override
    public String serve(AudioStream stream) {
        String streamId = UUID.randomUUID().toString();
        this.oneTimeStreams.put(streamId, stream);
        return this.getRelativeURL(streamId);
    }

    @Override
    public String serve(FixedLengthAudioStream stream, int seconds) {
        String streamId = UUID.randomUUID().toString();
        this.multiTimeStreams.put(streamId, stream);
        this.streamTimeouts.put(streamId, System.nanoTime() + TimeUnit.SECONDS.toNanos(seconds));
        return this.getRelativeURL(streamId);
    }

    private String getRelativeURL(String streamId) {
        return "/audio/" + streamId;
    }
}

