/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.autoupdate.internal;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.autoupdate.AutoUpdateBindingConfigProvider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.AbstractItemEventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateBinding
extends AbstractItemEventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(AutoUpdateBinding.class);
    protected volatile ItemRegistry itemRegistry;
    protected Collection<AutoUpdateBindingConfigProvider> providers = new CopyOnWriteArraySet<AutoUpdateBindingConfigProvider>();
    protected EventPublisher eventPublisher = null;

    public void addBindingConfigProvider(AutoUpdateBindingConfigProvider provider) {
        this.providers.add(provider);
    }

    public void removeBindingConfigProvider(AutoUpdateBindingConfigProvider provider) {
        this.providers.remove(provider);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
        Command command = commandEvent.getItemCommand();
        if (command instanceof State) {
            State state = (State)command;
            String itemName = commandEvent.getItemName();
            Boolean autoUpdate = this.autoUpdate(itemName);
            if (autoUpdate == null) {
                autoUpdate = Boolean.TRUE;
            }
            if (autoUpdate.booleanValue()) {
                this.postUpdate(itemName, state);
            } else {
                this.logger.trace("Won't update item '{}' as it is not configured to update its state automatically.", (Object)itemName);
            }
        }
    }

    private Boolean autoUpdate(String itemName) {
        Boolean autoUpdate = null;
        for (AutoUpdateBindingConfigProvider provider : this.providers) {
            Boolean au = provider.autoUpdate(itemName);
            if (au == null) continue;
            if (au.booleanValue()) {
                return true;
            }
            if (autoUpdate != null) continue;
            autoUpdate = false;
        }
        return autoUpdate;
    }

    private void postUpdate(String itemName, State newState) {
        if (this.itemRegistry != null) {
            try {
                GenericItem item = (GenericItem)this.itemRegistry.getItem(itemName);
                boolean isAccepted = false;
                if (item.getAcceptedDataTypes().contains(newState.getClass())) {
                    isAccepted = true;
                } else {
                    for (Class state : item.getAcceptedDataTypes()) {
                        try {
                            if (state.isEnum() || !((State)state.newInstance()).getClass().isAssignableFrom(newState.getClass())) continue;
                            isAccepted = true;
                            break;
                        }
                        catch (InstantiationException e) {
                            this.logger.warn("InstantiationException on {}", (Object)e.getMessage(), (Object)e);
                        }
                        catch (IllegalAccessException e) {
                            this.logger.warn("IllegalAccessException on {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
                if (isAccepted) {
                    this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)itemName, (State)newState, (String)"org.eclipse.smarthome.core.autoupdate"));
                } else {
                    this.logger.debug("Received update of a not accepted type ({}) for item {}", (Object)newState.getClass().getSimpleName(), (Object)itemName);
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("Received update for non-existing item: {}", (Object)e.getMessage());
            }
        }
    }
}

