/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.extension.sample.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.extension.Extension;
import org.eclipse.smarthome.core.extension.ExtensionEvent;
import org.eclipse.smarthome.core.extension.ExtensionEventFactory;
import org.eclipse.smarthome.core.extension.ExtensionService;
import org.eclipse.smarthome.core.extension.ExtensionType;

public class SampleExtensionService
implements ExtensionService {
    private static final String LOREM_IPSUM = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";
    private static final String[] COLOR_VALUES = new String[]{"80", "C8", "FF"};
    private EventPublisher eventPublisher;
    List<ExtensionType> types = new ArrayList<ExtensionType>(3);
    Map<String, Extension> extensions = new HashMap<String, Extension>(30);
    private static final Random random = new Random();

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void activate() {
        this.types.add(new ExtensionType("binding", "Bindings"));
        this.types.add(new ExtensionType("ui", "User Interfaces"));
        this.types.add(new ExtensionType("persistence", "Persistence Services"));
        for (ExtensionType type : this.types) {
            int i = 0;
            while (i < 10) {
                String id = String.valueOf(type.getId()) + Integer.toString(i);
                boolean installed = Math.random() > 0.5;
                String name = RandomStringUtils.randomAlphabetic((int)5);
                String label = String.valueOf(name) + " " + StringUtils.capitalize((String)type.getId());
                String typeId = type.getId();
                String version = "1.0";
                String link = Math.random() < 0.5 ? null : "http://lmgtfy.com/?q=" + name;
                String description = this.createDescription();
                String imageLink = null;
                String backgroundColor = this.createRandomColor();
                Extension extension = new Extension(id, typeId, label, version, link, installed, description, backgroundColor, imageLink);
                this.extensions.put(extension.getId(), extension);
                ++i;
            }
        }
    }

    private String createRandomColor() {
        StringBuilder ret = new StringBuilder("#");
        int i = 0;
        while (i < 3) {
            ret.append(COLOR_VALUES[random.nextInt(COLOR_VALUES.length)]);
            ++i;
        }
        return ret.toString();
    }

    private String createDescription() {
        int index = StringUtils.indexOf((String)LOREM_IPSUM, (char)' ', (int)random.nextInt(LOREM_IPSUM.length()));
        if (index < 0) {
            index = LOREM_IPSUM.length();
        }
        return LOREM_IPSUM.substring(0, index);
    }

    protected void deactivate() {
        this.types.clear();
        this.extensions.clear();
    }

    public void install(String id) {
        try {
            Thread.sleep((long)(Math.random() * 10000.0));
            Extension extension = this.getExtension(id, null);
            extension.setInstalled(true);
            this.postInstalledEvent(id);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void uninstall(String id) {
        try {
            Thread.sleep((long)(Math.random() * 5000.0));
            Extension extension = this.getExtension(id, null);
            extension.setInstalled(false);
            this.postUninstalledEvent(id);
        }
        catch (InterruptedException interruptedException) {}
    }

    public List<Extension> getExtensions(Locale locale) {
        return new ArrayList<Extension>(this.extensions.values());
    }

    public Extension getExtension(String id, Locale locale) {
        return this.extensions.get(id);
    }

    public List<ExtensionType> getTypes(Locale locale) {
        return this.types;
    }

    public String getExtensionId(URI extensionURI) {
        return null;
    }

    private void postInstalledEvent(String extensionId) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionInstalledEvent((String)extensionId);
            this.eventPublisher.post((Event)event);
        }
    }

    private void postUninstalledEvent(String extensionId) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionUninstalledEvent((String)extensionId);
            this.eventPublisher.post((Event)event);
        }
    }
}

