/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.persistence.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceConfiguration;
import org.eclipse.smarthome.core.persistence.SimpleItemConfiguration;
import org.eclipse.smarthome.core.persistence.internal.PersistenceManagerImpl;
import org.eclipse.smarthome.core.persistence.strategy.SimpleStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistItemsJob
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(PersistItemsJob.class);
    private final PersistenceManagerImpl manager;
    private final String dbId;
    private final String strategyName;

    public PersistItemsJob(PersistenceManagerImpl manager, String dbId, String strategyName) {
        this.manager = manager;
        this.dbId = dbId;
        this.strategyName = strategyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<String, PersistenceServiceConfiguration> map = this.manager.persistenceServiceConfigs;
        synchronized (map) {
            PersistenceService persistenceService = this.manager.persistenceServices.get(this.dbId);
            PersistenceServiceConfiguration config = this.manager.persistenceServiceConfigs.get(this.dbId);
            if (persistenceService != null) {
                for (SimpleItemConfiguration itemConfig : config.getConfigs()) {
                    if (!this.hasStrategy(config.getDefaults(), itemConfig, this.strategyName)) continue;
                    for (Item item : this.manager.getAllItems(itemConfig)) {
                        long startTime = System.nanoTime();
                        persistenceService.store(item, itemConfig.getAlias());
                        this.logger.trace("Storing item '{}' with persistence service '{}' took {}ms", new Object[]{item.getName(), this.dbId, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)});
                    }
                }
            }
        }
    }

    private boolean hasStrategy(List<SimpleStrategy> defaults, SimpleItemConfiguration config, String strategyName) {
        for (SimpleStrategy strategy : config.getStrategies()) {
            if (!strategyName.equals(strategy.getName())) continue;
            return true;
        }
        return config.getStrategies().isEmpty() && this.isDefault(defaults, strategyName);
    }

    private boolean isDefault(List<SimpleStrategy> defaults, String strategyName) {
        for (SimpleStrategy strategy : defaults) {
            if (!strategy.getName().equals(strategyName)) continue;
            return true;
        }
        return false;
    }
}

