/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConsoleCommandExtension.class})
public class LinkConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_CL_ADD = "addChannelLink";
    private static final String SUBCMD_CL_REMOVE = "removeChannelLink";
    private static final String SUBCMD_CLEAR = "clear";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;

    public LinkConsoleCommandExtension() {
        super("links", "Manage your links.");
    }

    public void execute(String[] args, Console console) {
        block22: {
            block20: {
                String subCommand;
                if (args.length <= 0) break block20;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.list(console, this.itemChannelLinkRegistry.getAll());
                        return;
                    }
                    case "addChannelLink": {
                        if (args.length > 2) {
                            String itemName = args[1];
                            ChannelUID channelUID = new ChannelUID(args[2]);
                            this.addChannelLink(console, itemName, channelUID);
                        } else {
                            console.println("Specify item name and channel UID to link: link <itemName> <channelUID>");
                        }
                        return;
                    }
                    case "removeChannelLink": {
                        if (args.length > 2) {
                            String itemName = args[1];
                            ChannelUID channelUID = new ChannelUID(args[2]);
                            this.removeChannelLink(console, itemName, channelUID);
                        } else {
                            console.println("Specify item name and channel UID to unlink: link <itemName> <channelUID>");
                        }
                        return;
                    }
                    case "clear": {
                        this.clear(console);
                        return;
                    }
                }
                console.println("Unknown command '" + subCommand + "'");
                this.printUsage(console);
                break block22;
            }
            this.printUsage(console);
        }
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage(SUBCMD_LIST, "lists all links"), this.buildCommandUsage("addChannelLink <itemName> <channelUID>", "links an item with a channel"), this.buildCommandUsage("removeChannelLink <itemName> <thingUID>", "unlinks an item with a channel"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all managed links"));
    }

    private void clear(Console console) {
        Collection itemChannelLinks = this.itemChannelLinkRegistry.getAll();
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            this.itemChannelLinkRegistry.remove(itemChannelLink.getUID());
        }
        console.println(String.valueOf(itemChannelLinks.size()) + " links successfully removed.");
    }

    private void addChannelLink(Console console, String itemName, ChannelUID channelUID) {
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUID);
        this.itemChannelLinkRegistry.add(itemChannelLink);
        console.println("Link " + itemChannelLink.toString() + " successfully added.");
    }

    private void list(Console console, Collection<ItemChannelLink> itemChannelLinks) {
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            console.println(itemChannelLink.toString());
        }
    }

    private void removeChannelLink(Console console, String itemName, ChannelUID channelUID) {
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUID);
        ItemChannelLink removedItemChannelLink = (ItemChannelLink)this.itemChannelLinkRegistry.remove(itemChannelLink.getUID());
        if (removedItemChannelLink != null) {
            console.println("Link " + itemChannelLink.toString() + "successfully removed.");
        } else {
            console.println("Could not remove link " + itemChannelLink.toString() + ".");
        }
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }
}

