/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.AbstractTypedEventSubscriber;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoChangedEvent;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.eclipse.smarthome.core.thing.util.ThingHandlerHelper;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.links", service={ThingLinkManager.class, EventSubscriber.class}, property={"service.config.description.uri:String=system:links", "service.config.label:String=Item Linking", "service.config.category:String=system", "service.pid:String=org.eclipse.smarthome.links"})
public class ThingLinkManager
extends AbstractTypedEventSubscriber<ThingStatusInfoChangedEvent> {
    private static final String THREADPOOL_NAME = "thingLinkManager";
    private final Logger logger = LoggerFactory.getLogger(ThingLinkManager.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"thingLinkManager");
    private ThingRegistry thingRegistry;
    private ManagedThingProvider managedThingProvider;
    private ItemRegistry itemRegistry;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private boolean autoLinks = true;
    private final RegistryChangeListener<Item> itemRegistryChangeListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            for (ChannelUID channelUID : ThingLinkManager.this.itemChannelLinkRegistry.getBoundChannels(element.getName())) {
                Channel channel;
                Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
                if (thing == null || (channel = thing.getChannel(channelUID.getId())) == null) continue;
                ThingLinkManager.this.informHandlerAboutLinkedChannel(thing, channel);
            }
        }

        public void removed(Item element) {
            for (ChannelUID channelUID : ThingLinkManager.this.itemChannelLinkRegistry.getBoundChannels(element.getName())) {
                Channel channel;
                Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
                if (thing == null || (channel = thing.getChannel(channelUID.getId())) == null) continue;
                ThingLinkManager.this.informHandlerAboutUnlinkedChannel(thing, channel);
            }
        }

        public void updated(Item oldElement, Item element) {
            if (!oldElement.equals(element)) {
                this.removed(oldElement);
                this.added(element);
            }
        }
    };
    private final RegistryChangeListener<ItemChannelLink> itemChannelLinkRegistryChangeListener = new RegistryChangeListener<ItemChannelLink>(){

        public void added(ItemChannelLink itemChannelLink) {
            Channel channel;
            if (ThingLinkManager.this.itemRegistry.get((Object)itemChannelLink.getItemName()) == null) {
                return;
            }
            ChannelUID channelUID = itemChannelLink.getLinkedUID();
            Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
            if (thing != null && (channel = thing.getChannel(channelUID.getId())) != null) {
                ThingLinkManager.this.informHandlerAboutLinkedChannel(thing, channel);
            }
        }

        public void removed(ItemChannelLink itemChannelLink) {
            Channel channel;
            ChannelUID channelUID = itemChannelLink.getLinkedUID();
            Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
            if (thing != null && (channel = thing.getChannel(channelUID.getId())) != null) {
                ThingLinkManager.this.informHandlerAboutUnlinkedChannel(thing, channel);
            }
        }

        public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
            if (!oldElement.equals(element)) {
                this.removed(oldElement);
                this.added(element);
            }
        }
    };
    private final ProviderChangeListener<Thing> managedThingProviderListener = new ProviderChangeListener<Thing>(){

        public void added(Provider<Thing> provider, Thing thing) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                this.createLinkIfNotAdvanced(channel);
            }
        }

        private void createLinkIfNotAdvanced(Channel channel) {
            if (ThingLinkManager.this.autoLinks) {
                ChannelType type;
                if (channel.getChannelTypeUID() != null && (type = TypeResolver.resolve(channel.getChannelTypeUID())) != null && type.isAdvanced()) {
                    return;
                }
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.add(link);
            }
        }

        public void removed(Provider<Thing> provider, Thing thing) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.remove(link.getUID());
            }
        }

        public void updated(Provider<Thing> provider, Thing oldThing, Thing newThing) {
            for (Channel channel : oldThing.getChannels()) {
                if (newThing.getChannel(channel.getUID().getId()) != null) continue;
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.remove(link.getUID());
            }
            for (Channel channel : newThing.getChannels()) {
                if (oldThing.getChannel(channel.getUID().getId()) != null) continue;
                this.createLinkIfNotAdvanced(channel);
            }
        }

        private String deriveItemName(ChannelUID uid) {
            return uid.getAsString().replaceAll("[^a-zA-Z0-9_]", "_");
        }
    };

    public ThingLinkManager() {
        super(ThingStatusInfoChangedEvent.TYPE);
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.modified(context);
        this.itemRegistry.addRegistryChangeListener(this.itemRegistryChangeListener);
        this.itemChannelLinkRegistry.addRegistryChangeListener(this.itemChannelLinkRegistryChangeListener);
        this.managedThingProvider.addProviderChangeListener(this.managedThingProviderListener);
    }

    @Modified
    protected void modified(ComponentContext context) {
        if (context != null) {
            Object value = context.getProperties().get("autoLinks");
            this.autoLinks = value == null || !value.toString().equals("false");
        }
    }

    @Deactivate
    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener(this.itemRegistryChangeListener);
        this.itemChannelLinkRegistry.removeRegistryChangeListener(this.itemChannelLinkRegistryChangeListener);
        this.managedThingProvider.removeProviderChangeListener(this.managedThingProviderListener);
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    public boolean isAutoLinksEnabled() {
        return this.autoLinks;
    }

    private void informHandlerAboutLinkedChannel(Thing thing, Channel channel) {
        this.scheduler.submit(() -> {
            if (ThingHandlerHelper.isHandlerInitialized(thing)) {
                ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    try {
                        handler.channelLinked(channel.getUID());
                    }
                    catch (Exception ex) {
                        this.logger.error("Exception occurred while informing handler: {}", (Object)ex.getMessage(), (Object)ex);
                    }
                } else {
                    this.logger.trace("Can not inform handler about linked channel, because no handler is assigned to the thing {}.", (Object)thing.getUID());
                }
            }
        });
    }

    private void informHandlerAboutUnlinkedChannel(Thing thing, Channel channel) {
        this.scheduler.submit(() -> {
            if (ThingHandlerHelper.isHandlerInitialized(thing)) {
                ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    try {
                        handler.channelUnlinked(channel.getUID());
                    }
                    catch (Exception ex) {
                        this.logger.error("Exception occurred while informing handler: {}", (Object)ex.getMessage(), (Object)ex);
                    }
                } else {
                    this.logger.trace("Can not inform handler about unlinked channel, because no handler is assigned to the thing {}.", (Object)thing.getUID());
                }
            }
        });
    }

    protected void receiveTypedEvent(ThingStatusInfoChangedEvent event) {
        Thing thing;
        if (ThingStatus.INITIALIZING.equals((Object)event.getOldStatusInfo().getStatus()) && ThingHandlerHelper.isHandlerInitialized(event.getStatusInfo().getStatus()) && (thing = this.thingRegistry.get(event.getThingUID())) != null) {
            for (Channel channel : thing.getChannels()) {
                if (this.itemChannelLinkRegistry.getLinkedItemNames(channel.getUID()).size() <= 0) continue;
                this.informHandlerAboutLinkedChannel(thing, channel);
            }
        }
    }
}

