/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.smarthome.core.voice.text.ASTNode;
import org.eclipse.smarthome.core.voice.text.Expression;
import org.eclipse.smarthome.core.voice.text.TokenList;

public final class ExpressionSequence
extends Expression {
    private List<Expression> subExpressions;

    public ExpressionSequence(Expression ... subExpressions) {
        this.subExpressions = Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(subExpressions, subExpressions.length)));
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList tokenList) {
        TokenList list = tokenList;
        int l = this.subExpressions.size();
        ASTNode node = new ASTNode();
        ASTNode[] children = new ASTNode[l];
        Object[] values = new Object[l];
        int i = 0;
        while (i < l) {
            children[i] = this.subExpressions.get(i).parse(language, list);
            ASTNode cr = children[i];
            if (!cr.isSuccess()) {
                return node;
            }
            values[i] = cr.getValue();
            list = cr.getRemainingTokens();
            ++i;
        }
        node.setChildren(children);
        node.setRemainingTokens(list);
        node.setSuccess(true);
        node.setValue(values);
        this.generateValue(node);
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return this.subExpressions;
    }

    @Override
    boolean collectFirsts(ResourceBundle language, HashSet<String> firsts) {
        boolean blocking = false;
        for (Expression e : this.subExpressions) {
            blocking = e.collectFirsts(language, firsts);
            if (blocking) break;
        }
        return blocking;
    }

    public String toString() {
        String s = null;
        for (Expression e : this.subExpressions) {
            String string = s = s == null ? e.toString() : String.valueOf(s) + ", " + e.toString();
        }
        return "seq(" + s + ")";
    }
}

