/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.net.CidrAddress;
import org.eclipse.smarthome.core.net.NetworkAddressService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid="org.eclipse.smarthome.network", property={"service.pid=org.eclipse.smarthome.network", "service.config.description.uri=system:network", "service.config.label=Network Settings", "service.config.category=system"})
public class NetUtil
implements NetworkAddressService {
    private static final String PRIMARY_ADDRESS = "primaryAddress";
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private String primaryAddress;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.modified(props);
    }

    @Modified
    public synchronized void modified(Map<String, Object> config) {
        String primaryAddressConf = (String)config.get(PRIMARY_ADDRESS);
        this.primaryAddress = primaryAddressConf == null || primaryAddressConf.isEmpty() || !NetUtil.isValidIPConfig(primaryAddressConf) ? this.getFirstLocalIPv4Address() : primaryAddressConf;
    }

    @Override
    public String getPrimaryIpv4HostAddress() {
        String primaryIP;
        String[] addrString = this.primaryAddress.split("/");
        if (addrString.length > 1) {
            String ip = this.getIPv4inSubnet(addrString[0], addrString[1]);
            if (ip == null) {
                LOGGER.warn("Invalid address '{}', will use first interface instead.", (Object)this.primaryAddress);
                primaryIP = this.getFirstLocalIPv4Address();
            } else {
                primaryIP = ip;
            }
        } else {
            primaryIP = addrString[0];
        }
        return primaryIP;
    }

    @Deprecated
    public static String getLocalIpv4HostAddress() {
        try {
            String hostAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress current_addr = addresses.nextElement();
                    if (current_addr.isLoopbackAddress() || current_addr instanceof Inet6Address) continue;
                    if (hostAddress != null) {
                        LOGGER.warn("Found multiple local interfaces - ignoring {}", (Object)current_addr.getHostAddress());
                        continue;
                    }
                    hostAddress = current_addr.getHostAddress();
                }
            }
            return hostAddress;
        }
        catch (SocketException ex) {
            LOGGER.error("Could not retrieve network interface: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    private String getFirstLocalIPv4Address() {
        try {
            String hostAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress current_addr = addresses.nextElement();
                    if (current_addr.isLoopbackAddress() || current_addr instanceof Inet6Address) continue;
                    if (hostAddress != null) {
                        LOGGER.warn("Found multiple local interfaces - ignoring {}", (Object)current_addr.getHostAddress());
                        continue;
                    }
                    hostAddress = current_addr.getHostAddress();
                }
            }
            return hostAddress;
        }
        catch (SocketException ex) {
            LOGGER.error("Could not retrieve network interface: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public static List<String> getAllBroadcastAddresses() {
        LinkedList<String> broadcastAddresses = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress addr = interfaceAddress.getAddress();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    broadcastAddresses.add(interfaceAddress.getBroadcast().getHostAddress());
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.error("Could not find broadcast address: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return broadcastAddresses;
    }

    public static String getBroadcastAddress() {
        List<String> broadcastAddresses = NetUtil.getAllBroadcastAddresses();
        if (!broadcastAddresses.isEmpty()) {
            return broadcastAddresses.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<CidrAddress> getAllInterfaceAddresses() {
        interfaceIPs = new ArrayList<CidrAddress>();
        try {
            en = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl24
        }
        catch (SocketException ex) {
            NetUtil.LOGGER.error("Could not find interface IP addresses: {}", (Object)ex.getMessage(), (Object)ex);
            return interfaceIPs;
        }
        do {
            networkInterface = en.nextElement();
            try {
                if (!networkInterface.isUp()) continue;
                if (networkInterface.isLoopback()) {
                }
            }
            catch (SocketException ignored) {}
            continue;
            for (InterfaceAddress cidr : networkInterface.getInterfaceAddresses()) {
                address = cidr.getAddress();
                if (!NetUtil.$assertionsDisabled && address == null) {
                    throw new AssertionError();
                }
                interfaceIPs.add(new CidrAddress(address, cidr.getNetworkPrefixLength()));
            }
lbl24:
            // 5 sources

        } while (en.hasMoreElements());
        return interfaceIPs;
    }

    public static @NonNull String networkPrefixLengthToNetmask(int prefixLength) {
        if (prefixLength > 31 || prefixLength < 1) {
            throw new IllegalArgumentException("Network prefix length is not within bounds");
        }
        int ipv4Netmask = -1;
        byte[] octets = new byte[]{(byte)((ipv4Netmask <<= 32 - prefixLength) >>> 24), (byte)(ipv4Netmask >>> 16), (byte)(ipv4Netmask >>> 8), (byte)ipv4Netmask};
        String result = "";
        int i = 0;
        while (i < 4) {
            result = String.valueOf(result) + (octets[i] & 0xFF);
            if (i < 3) {
                result = String.valueOf(result) + ".";
            }
            ++i;
        }
        return result;
    }

    public static @NonNull String getIpv4NetAddress(@NonNull String ipAddressString, short netMask) {
        String errorString = "IP '" + ipAddressString + "' is not a valid IPv4 address";
        if (!NetUtil.isValidIPConfig(ipAddressString)) {
            throw new IllegalArgumentException(errorString);
        }
        if (netMask < 1 || netMask > 32) {
            throw new IllegalArgumentException("Netmask '" + netMask + "' is out of bounds (1-32)");
        }
        String subnetMaskString = NetUtil.networkPrefixLengthToNetmask(netMask);
        String[] netMaskOctets = subnetMaskString.split("\\.");
        String[] ipv4AddressOctets = ipAddressString.split("\\.");
        String netAddress = "";
        try {
            int i = 0;
            while (i < 4) {
                netAddress = String.valueOf(netAddress) + (Integer.parseInt(ipv4AddressOctets[i]) & Integer.parseInt(netMaskOctets[i]));
                if (i < 3) {
                    netAddress = String.valueOf(netAddress) + ".";
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(errorString);
        }
        return netAddress;
    }

    private String getIPv4inSubnet(String ipAddress, String subnetMask) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                for (InterfaceAddress ifAddr : current.getInterfaceAddresses()) {
                    String configuredSubnetString;
                    String ipv4AddressOnInterface;
                    String subnetStringOnInterface;
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.isLoopbackAddress() || addr instanceof Inet6Address || !(subnetStringOnInterface = String.valueOf(NetUtil.getIpv4NetAddress(ipv4AddressOnInterface = addr.getHostAddress(), ifAddr.getNetworkPrefixLength())) + "/" + String.valueOf(ifAddr.getNetworkPrefixLength())).equals(configuredSubnetString = String.valueOf(NetUtil.getIpv4NetAddress(ipAddress, Short.parseShort(subnetMask))) + "/" + subnetMask)) continue;
                    return ipv4AddressOnInterface;
                }
            }
        }
        catch (SocketException ex) {
            LOGGER.error("Could not retrieve network interface: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    public static boolean isValidIPConfig(String ipAddress) {
        if (ipAddress.contains("/")) {
            String[] parts = ipAddress.split("/");
            boolean ipMatches = IPV4_PATTERN.matcher(parts[0]).matches();
            int netMask = Integer.parseInt(parts[1]);
            boolean netMaskMatches = false;
            if (netMask > 0 || netMask < 32) {
                netMaskMatches = true;
            }
            return ipMatches && netMaskMatches;
        }
        return IPV4_PATTERN.matcher(ipAddress).matches();
    }
}

