/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchQueueReader
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(WatchQueueReader.class);
    protected WatchService watchService;
    private Map<WatchKey, Path> registeredKeys = new HashMap<WatchKey, Path>();
    private Map<WatchKey, AbstractWatchService> keyToService = new HashMap<WatchKey, AbstractWatchService>();
    private Thread qr;
    private static final WatchQueueReader INSTANCE = new WatchQueueReader();

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public static WatchQueueReader getInstance() {
        return INSTANCE;
    }

    private WatchQueueReader() {
    }

    protected void customizeWatchQueueReader(AbstractWatchService watchService, Path toWatch, boolean watchSubDirectories) {
        try {
            if (watchSubDirectories) {
                this.registerWithSubDirectories(watchService, toWatch);
            } else {
                this.registerDirectoryInternal(watchService, watchService.getWatchEventKinds(toWatch), toWatch);
            }
        }
        catch (NoSuchFileException e) {
            this.logger.debug("Not watching folder '{}' as it does not exist.", (Object)toWatch);
        }
        catch (IOException e) {
            this.logger.warn("Cannot customize folder watcher for folder '{}'", (Object)toWatch, (Object)e);
        }
    }

    private void registerWithSubDirectories(final AbstractWatchService watchService, Path toWatch) throws IOException {
        Files.walkFileTree(toWatch, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path subDir, BasicFileAttributes attrs) throws IOException {
                WatchEvent.Kind[] kinds = watchService.getWatchEventKinds(subDir);
                if (kinds != null) {
                    WatchQueueReader.this.registerDirectoryInternal(watchService, kinds, subDir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private synchronized void registerDirectoryInternal(AbstractWatchService service, WatchEvent.Kind<?>[] kinds, Path directory) {
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                this.qr = new Thread((Runnable)this, "Dir Watcher");
                this.qr.start();
            }
            catch (IOException e) {
                this.logger.debug("The directory '{}' was not registered in the watch service", (Object)directory, (Object)e);
                return;
            }
        }
        WatchKey registrationKey = null;
        try {
            registrationKey = directory.register(this.watchService, kinds);
        }
        catch (IOException e) {
            this.logger.debug("The directory '{}' was not registered in the watch service: {}", (Object)directory, (Object)e.getMessage());
        }
        if (registrationKey != null) {
            this.registeredKeys.put(registrationKey, directory);
            this.keyToService.put(registrationKey, service);
        } else {
            this.logger.debug("The directory '{}' was not registered in the watch service", (Object)directory);
        }
    }

    public synchronized void stopWatchService(AbstractWatchService service) {
        if (this.watchService != null) {
            LinkedList<WatchKey> keys = new LinkedList<WatchKey>();
            for (WatchKey key : this.keyToService.keySet()) {
                if (this.keyToService.get(key) != service) continue;
                keys.add(key);
            }
            if (keys.size() == this.keyToService.size()) {
                try {
                    this.watchService.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot deactivate folder watcher", (Throwable)e);
                }
                this.watchService = null;
                this.keyToService.clear();
                this.registeredKeys.clear();
            } else {
                for (WatchKey key : keys) {
                    key.cancel();
                    this.keyToService.remove(key);
                    this.registeredKeys.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key = null;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException exc) {
                    this.logger.info("Caught InterruptedException: {}", (Object)exc.getLocalizedMessage());
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.logger.warn("Found an event of kind 'OVERFLOW': {}. File system changes might have been missed.", event);
                        continue;
                    }
                    Path resolvedPath = this.resolvePath(key, event);
                    if (resolvedPath == null) continue;
                    AbstractWatchService service = null;
                    WatchQueueReader watchQueueReader = this;
                    synchronized (watchQueueReader) {
                        service = this.keyToService.get(key);
                    }
                    if (service == null) continue;
                    File f = resolvedPath.toFile();
                    service.processWatchEvent(event, kind, resolvedPath);
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE && f.isDirectory() && service.watchSubDirectories() && service.getWatchEventKinds(resolvedPath) != null) {
                        this.registerDirectoryInternal(service, service.getWatchEventKinds(resolvedPath), resolvedPath);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    WatchQueueReader watchQueueReader2 = this;
                    synchronized (watchQueueReader2) {
                        WatchKey toCancel = null;
                        for (WatchKey k : this.registeredKeys.keySet()) {
                            if (!this.registeredKeys.get(k).equals(resolvedPath)) continue;
                            toCancel = k;
                            break;
                        }
                        if (toCancel != null) {
                            this.registeredKeys.remove(toCancel);
                            this.keyToService.remove(toCancel);
                            toCancel.cancel();
                        }
                    }
                }
                key.reset();
            }
        }
        catch (Exception exc) {
            this.logger.debug("ClosedWatchServiceException caught! {}. \n{} Stopping ", (Object)exc.getLocalizedMessage(), (Object)Thread.currentThread().getName());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(WatchKey key, WatchEvent<?> event) {
        WatchEvent ev = WatchQueueReader.cast(event);
        Path contextPath = (Path)ev.context();
        Path baseWatchedDir = null;
        Path registeredPath = null;
        WatchQueueReader watchQueueReader = this;
        synchronized (watchQueueReader) {
            baseWatchedDir = this.keyToService.get(key).getSourcePath();
            registeredPath = this.registeredKeys.get(key);
        }
        if (registeredPath != null) {
            Path resolvedContextPath = registeredPath.resolve(contextPath);
            Path path = baseWatchedDir.relativize(resolvedContextPath);
            if (baseWatchedDir.resolve(path).toFile().isDirectory() && !this.isWatchingDirectoryChanges(key, resolvedContextPath)) {
                return null;
            }
            return resolvedContextPath;
        }
        this.logger.warn("Detected invalid WatchEvent '{}' and key '{}' for entry '{}' in not registered file or directory of '{}'", new Object[]{event, key, contextPath, baseWatchedDir});
        return null;
    }

    private boolean isWatchingDirectoryChanges(WatchKey key, Path resolvedContextPath) {
        return this.keyToService.get(key).getWatchingDirectoryChanges(resolvedContextPath);
    }
}

