/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.extensionservice.marketplace.automation.internal;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtension;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtensionHandler;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceHandlerException;
import org.eclipse.smarthome.extensionservice.marketplace.automation.internal.MarketplaceRuleTemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationExtensionHandler
implements MarketplaceExtensionHandler {
    private final Logger logger = LoggerFactory.getLogger(AutomationExtensionHandler.class);
    private MarketplaceRuleTemplateProvider marketplaceRuleTemplateProvider;

    protected void setMarketplaceRuleTemplateProvider(MarketplaceRuleTemplateProvider marketplaceRuleTemplateProvider) {
        this.marketplaceRuleTemplateProvider = marketplaceRuleTemplateProvider;
    }

    protected void unsetMarketplaceRuleTemplateProvider(MarketplaceRuleTemplateProvider marketplaceRuleTemplateProvider) {
        this.marketplaceRuleTemplateProvider = null;
    }

    public boolean supports(MarketplaceExtension ext) {
        return ext.getType().equals("ruletemplate") && ext.getPackageFormat().equals("json");
    }

    public boolean isInstalled(MarketplaceExtension ext) {
        return this.marketplaceRuleTemplateProvider.get(ext.getId()) != null;
    }

    public void install(MarketplaceExtension ext) throws MarketplaceHandlerException {
        String url = ext.getDownloadUrl();
        try {
            String template = this.getTemplate(url);
            this.marketplaceRuleTemplateProvider.addTemplateAsJSON(ext.getId(), template);
        }
        catch (IOException e) {
            this.logger.error("Rule template from marketplace cannot be downloaded: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Template cannot be downloaded.");
        }
        catch (Exception e) {
            this.logger.error("Rule template from marketplace is invalid: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Template is not valid.");
        }
    }

    public void uninstall(MarketplaceExtension ext) throws MarketplaceHandlerException {
        this.marketplaceRuleTemplateProvider.remove(ext.getId());
    }

    private String getTemplate(String urlString) throws IOException {
        URL url = new URL(urlString);
        return IOUtils.toString((URL)url);
    }
}

