/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.extensionservice.marketplace.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.extensionservice.marketplace.internal.MarketplaceXMLReader;
import org.eclipse.smarthome.extensionservice.marketplace.internal.model.Marketplace;
import org.eclipse.smarthome.extensionservice.marketplace.internal.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceProxy {
    private final Logger logger = LoggerFactory.getLogger(MarketplaceProxy.class);
    private static final String MP_URL = "https://marketplace.eclipse.org/taxonomy/term/4988%2C4396/api/p?client=org.eclipse.smarthome";
    private final URL url;
    private Node[] cachedNodes = null;
    private long refresh_interval = 3600L;
    private long retry_delay = 60L;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> refreshJob;

    public MarketplaceProxy() {
        try {
            this.url = new URL(MP_URL);
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            this.refreshJob = this.executorService.scheduleWithFixedDelay(() -> this.refresh(), 0L, this.refresh_interval, TimeUnit.SECONDS);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Something is very wrong - cannot instantiate URL https://marketplace.eclipse.org/taxonomy/term/4988%2C4396/api/p?client=org.eclipse.smarthome");
        }
    }

    public List<Node> getNodes() {
        return this.cachedNodes != null ? Arrays.asList(this.cachedNodes) : Collections.emptyList();
    }

    public synchronized void refresh() {
        MarketplaceXMLReader reader = new MarketplaceXMLReader();
        try {
            Marketplace result = (Marketplace)reader.readFromXML(this.url);
            this.cachedNodes = result.categories[0].nodes;
        }
        catch (Exception e) {
            if (this.cachedNodes == null) {
                this.logger.warn("Failed downloading Marketplace entries: {}", (Object)e.getMessage());
                this.logger.warn("Retrying again in a minute");
                this.executorService.schedule(() -> this.refresh(), this.retry_delay, TimeUnit.SECONDS);
            }
            this.logger.debug("Cannot access IoT Marketplace - will continue to use cached results: {}", (Object)e.getMessage());
        }
    }

    public void dispose() {
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
        this.executorService.shutdown();
    }
}

