/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.smarthome.core.library.types.RawType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final int DEFAULT_TIMEOUT_MS = 5000;
    private static final HttpClient CLIENT = new HttpClient(new SslContextFactory());

    public static String executeUrl(String httpMethod, String url, int timeout) throws IOException {
        return HttpUtil.executeUrl(httpMethod, url, null, null, timeout);
    }

    public static String executeUrl(String httpMethod, String url, InputStream content, String contentType, int timeout) throws IOException {
        return HttpUtil.executeUrl(httpMethod, url, null, content, contentType, timeout);
    }

    public static String executeUrl(String httpMethod, String url, Properties httpHeaders, InputStream content, String contentType, int timeout) throws IOException {
        ProxyParams proxyParams = HttpUtil.prepareProxyParams();
        return HttpUtil.executeUrl(httpMethod, url, httpHeaders, content, contentType, timeout, proxyParams.proxyHost, proxyParams.proxyPort, proxyParams.proxyUser, proxyParams.proxyPassword, proxyParams.nonProxyHosts);
    }

    public static String executeUrl(String httpMethod, String url, Properties httpHeaders, InputStream content, String contentType, int timeout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String nonProxyHosts) throws IOException {
        String responseBody;
        ContentResponse response = HttpUtil.executeUrlAndGetReponse(httpMethod, url, httpHeaders, content, contentType, timeout, proxyHost, proxyPort, proxyUser, proxyPassword, nonProxyHosts);
        String encoding = response.getEncoding() != null ? response.getEncoding().replaceAll("\"", "").trim() : "UTF-8";
        try {
            responseBody = new String(response.getContent(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            responseBody = null;
        }
        return responseBody;
    }

    private static ContentResponse executeUrlAndGetReponse(String httpMethod, String url, Properties httpHeaders, InputStream content, String contentType, int timeout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String nonProxyHosts) throws IOException {
        HttpUtil.startHttpClient(CLIENT);
        HttpProxy proxy = null;
        if (StringUtils.isNotBlank((String)proxyHost) && proxyPort != null && HttpUtil.shouldUseProxy(url, nonProxyHosts)) {
            AuthenticationStore authStore = CLIENT.getAuthenticationStore();
            ProxyConfiguration proxyConfig = CLIENT.getProxyConfiguration();
            List proxies = proxyConfig.getProxies();
            proxy = new HttpProxy(proxyHost, proxyPort.intValue());
            proxies.add(proxy);
            authStore.addAuthentication((Authentication)new BasicAuthentication(proxy.getURI(), "<<ANY_REALM>>", proxyUser, proxyPassword));
        }
        HttpMethod method = HttpUtil.createHttpMethod(httpMethod);
        Request request = CLIENT.newRequest(url).method(method).timeout((long)timeout, TimeUnit.MILLISECONDS);
        if (httpHeaders != null) {
            for (String httpHeaderKey : httpHeaders.stringPropertyNames()) {
                request.header(httpHeaderKey, httpHeaders.getProperty(httpHeaderKey));
            }
        }
        try {
            URI uri = new URI(url);
            if (uri.getUserInfo() != null) {
                String[] userInfo = uri.getUserInfo().split(":");
                String user = userInfo[0];
                String password = userInfo[1];
                String basicAuthentication = "Basic " + B64Code.encode((String)(String.valueOf(user) + ":" + password), (String)"iso-8859-1");
                request.header(HttpHeader.AUTHORIZATION, basicAuthentication);
            }
        }
        catch (URISyntaxException e) {
            logger.debug("String {} can not be parsed as URI reference", (Object)url);
        }
        if (content != null && (method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT))) {
            request.content((ContentProvider)new InputStreamContentProvider(content), contentType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("About to execute {}", (Object)request.getURI());
        }
        try {
            ContentResponse response = request.send();
            int statusCode = response.getStatus();
            if (statusCode >= 400) {
                String statusLine = String.valueOf(statusCode) + " " + response.getReason();
                logger.debug("Method failed: {}", (Object)statusLine);
            }
            ContentResponse contentResponse = response;
            return contentResponse;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (proxy != null) {
                CLIENT.getProxyConfiguration().getProxies().remove(proxy);
            }
        }
    }

    private static ProxyParams prepareProxyParams() {
        ProxyParams proxyParams = new ProxyParams();
        String proxySet = System.getProperty("http.proxySet");
        if ("true".equalsIgnoreCase(proxySet)) {
            proxyParams.proxyHost = System.getProperty("http.proxyHost");
            String proxyPortString = System.getProperty("http.proxyPort");
            if (StringUtils.isNotBlank((String)proxyPortString)) {
                try {
                    proxyParams.proxyPort = Integer.valueOf(proxyPortString);
                }
                catch (NumberFormatException e) {
                    logger.warn("'{}' is not a valid proxy port - using default port ({}) instead", (Object)proxyPortString, (Object)proxyParams.proxyPort);
                }
            }
            proxyParams.proxyUser = System.getProperty("http.proxyUser");
            proxyParams.proxyPassword = System.getProperty("http.proxyPassword");
            proxyParams.nonProxyHosts = System.getProperty("http.nonProxyHosts");
        }
        return proxyParams;
    }

    private static boolean shouldUseProxy(String urlString, String nonProxyHosts) {
        if (StringUtils.isNotBlank((String)nonProxyHosts)) {
            String[] hosts;
            String givenHost = urlString;
            try {
                URL url = new URL(urlString);
                givenHost = url.getHost();
            }
            catch (MalformedURLException e) {
                logger.error("the given url {} is malformed", (Object)urlString);
            }
            String[] stringArray = hosts = nonProxyHosts.split("\\|");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                if (host.contains("*")) {
                    String hostRegexp = host.replaceAll("\\.", "\\\\.");
                    if (givenHost.matches(hostRegexp = hostRegexp.replaceAll("\\*", ".*"))) {
                        return false;
                    }
                } else if (givenHost.equals(host)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static HttpMethod createHttpMethod(String httpMethodString) {
        if ("GET".equals(httpMethodString)) {
            return HttpMethod.GET;
        }
        if ("PUT".equals(httpMethodString)) {
            return HttpMethod.PUT;
        }
        if ("POST".equals(httpMethodString)) {
            return HttpMethod.POST;
        }
        if ("DELETE".equals(httpMethodString)) {
            return HttpMethod.DELETE;
        }
        throw new IllegalArgumentException("given httpMethod '" + httpMethodString + "' is unknown");
    }

    private static void startHttpClient(HttpClient client) {
        if (!client.isStarted()) {
            try {
                client.start();
            }
            catch (Exception e) {
                logger.warn("Cannot start HttpClient!", (Throwable)e);
            }
        }
    }

    public static RawType downloadImage(String url) {
        return HttpUtil.downloadImage(url, 5000);
    }

    public static RawType downloadImage(String url, int timeout) {
        return HttpUtil.downloadImage(url, true, -1L, timeout);
    }

    public static RawType downloadImage(String url, boolean scanTypeInContent, long maxContentLength) {
        return HttpUtil.downloadImage(url, scanTypeInContent, maxContentLength, 5000);
    }

    public static RawType downloadImage(String url, boolean scanTypeInContent, long maxContentLength, int timeout) {
        return HttpUtil.downloadData(url, "image/.*", scanTypeInContent, maxContentLength, timeout);
    }

    public static RawType downloadData(String url, String contentTypeRegex, boolean scanTypeInContent, long maxContentLength) {
        return HttpUtil.downloadData(url, contentTypeRegex, scanTypeInContent, maxContentLength, 5000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawType downloadData(String url, String contentTypeRegex, boolean scanTypeInContent, long maxContentLength, int timeout) {
        ProxyParams proxyParams = HttpUtil.prepareProxyParams();
        RawType rawData = null;
        try {
            ContentResponse response = HttpUtil.executeUrlAndGetReponse("GET", url, null, null, null, timeout, proxyParams.proxyHost, proxyParams.proxyPort, proxyParams.proxyUser, proxyParams.proxyPassword, proxyParams.nonProxyHosts);
            byte[] data = response.getContent();
            long length = data == null ? 0 : data.length;
            String mediaType = response.getMediaType();
            logger.debug("Media download response: status {} content length {} media type {} (URL {})", new Object[]{response.getStatus(), length, mediaType, url});
            if (response.getStatus() != 200 || length == 0L) {
                logger.debug("Media download failed: unexpected return code {} (URL {})", (Object)response.getStatus(), (Object)url);
                return null;
            }
            if (maxContentLength >= 0L && length > maxContentLength) {
                logger.debug("Media download aborted: content length {} too big (URL {})", (Object)length, (Object)url);
                return null;
            }
            String contentType = mediaType;
            if (contentTypeRegex != null) {
                if ((contentType == null || contentType.isEmpty()) && scanTypeInContent) {
                    contentType = HttpUtil.guessContentTypeFromData(data);
                    logger.debug("Media download: content type from data: {} (URL {})", (Object)contentType, (Object)url);
                }
                if (contentType != null && contentType.isEmpty()) {
                    contentType = null;
                }
                if (contentType == null) {
                    logger.debug("Media download aborted: unknown content type (URL {})", (Object)url);
                    return null;
                }
                if (!contentType.matches(contentTypeRegex)) {
                    logger.debug("Media download aborted: unexpected content type \"{}\" (URL {})", (Object)contentType, (Object)url);
                    return null;
                }
            } else if (contentType == null || contentType.isEmpty()) {
                contentType = "application/octet-stream";
            }
            rawData = new RawType(data, contentType);
        }
        catch (IOException e) {
            rawData = null;
        }
        if (rawData == null) {
            logger.debug("Media download failed (URL {})", (Object)url);
            return rawData;
        }
        logger.debug("Media downloaded: size {} type {} (URL {})", new Object[]{rawData.getBytes().length, rawData.getMimeType(), url});
        return rawData;
    }

    public static String guessContentTypeFromData(byte[] data) {
        String contentType = null;
        if (HttpUtil.isJpeg(data)) {
            return "image/jpeg";
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
                try {
                    contentType = URLConnection.guessContentTypeFromStream(input);
                    if (contentType != null && contentType.isEmpty()) {
                        contentType = null;
                    }
                }
                catch (IOException e) {
                    logger.debug("Failed to determine content type: {}", (Object)e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contentType;
    }

    private static boolean isJpeg(byte[] data) {
        return data.length >= 2 && data[0] == -1 && data[1] == -40 && data[data.length - 2] == -1 && data[data.length - 1] == -39;
    }

    private static class ProxyParams {
        public String proxyHost = null;
        public int proxyPort = 80;
        public String proxyUser = null;
        public String proxyPassword = null;
        public String nonProxyHosts = null;

        private ProxyParams() {
        }
    }
}

