/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.persistence;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.ModifiablePersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceRegistry;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.persistence.dto.ItemHistoryDTO;
import org.eclipse.smarthome.core.persistence.dto.PersistenceServiceDTO;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="persistence")
@Api(value="persistence")
@Component(service={RESTResource.class, PersistenceResource.class})
public class PersistenceResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(PersistenceResource.class);
    private final int MILLISECONDS_PER_DAY = 86400000;
    private final String MODIFYABLE = "Modifiable";
    private final String QUERYABLE = "Queryable";
    private final String STANDARD = "Standard";
    public static final String PATH = "persistence";
    private ItemRegistry itemRegistry;
    private PersistenceServiceRegistry persistenceServiceRegistry;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setPersistenceServiceRegistry(PersistenceServiceRegistry persistenceServiceRegistry) {
        this.persistenceServiceRegistry = persistenceServiceRegistry;
    }

    protected void unsetPersistenceServiceRegistry(PersistenceServiceRegistry persistenceServiceRegistry) {
        this.persistenceServiceRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a list of persistence services.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class, responseContainer="List")})
    public Response httpGetPersistenceServices(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        List<PersistenceServiceDTO> responseObject = this.getPersistenceServiceList(locale);
        return Response.ok(responseObject).build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/items")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a list of items available via a specific persistence service.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class, responseContainer="List")})
    public Response httpGetPersistenceServiceItems(@Context HttpHeaders headers, @ApiParam(value="Id of the persistence service. If not provided the default service will be used", required=false) @QueryParam(value="serviceId") String serviceId) {
        return this.getServiceItemList(serviceId);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets item persistence data from the persistence service.", response=ItemHistoryDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ItemHistoryDTO.class), @ApiResponse(code=404, message="Unknown Item or persistence service")})
    public Response httpGetPersistenceItemData(@Context HttpHeaders headers, @ApiParam(value="Id of the persistence service. If not provided the default service will be used", required=false) @QueryParam(value="serviceId") String serviceId, @ApiParam(value="The item name", required=true) @PathParam(value="itemname") String itemName, @ApiParam(value="Start time of the data to return. Will default to 1 day before endtime. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=false) @QueryParam(value="starttime") String startTime, @ApiParam(value="End time of the data to return. Will default to current time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=false) @QueryParam(value="endtime") String endTime, @ApiParam(value="Page number of data to return. This parameter will enable paging.", required=false) @QueryParam(value="page") int pageNumber, @ApiParam(value="The length of each page.", required=false) @QueryParam(value="pagelength") int pageLength, @ApiParam(value="Gets one value before and after the requested period.", required=false) @QueryParam(value="boundary") boolean boundary) {
        return this.getItemHistoryDTO(serviceId, itemName, startTime, endTime, pageNumber, pageLength, boundary);
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete item data from a specific persistence service.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid filter parameters"), @ApiResponse(code=404, message="Unknown persistence service")})
    public Response httpDeletePersistenceServiceItem(@Context HttpHeaders headers, @ApiParam(value="Id of the persistence service.", required=true) @QueryParam(value="serviceId") String serviceId, @ApiParam(value="The item name.", required=true) @PathParam(value="itemname") String itemName, @ApiParam(value="Start time of the data to return. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="starttime") String startTime, @ApiParam(value="End time of the data to return. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="endtime") String endTime) {
        return this.deletePersistenceItemData(serviceId, itemName, startTime, endTime);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Stores item persistence data into the persistence service.", response=ItemHistoryDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ItemHistoryDTO.class), @ApiResponse(code=404, message="Unknown Item or persistence service")})
    public Response httpPutPersistenceItemData(@Context HttpHeaders headers, @ApiParam(value="Id of the persistence service. If not provided the default service will be used", required=false) @QueryParam(value="serviceId") String serviceId, @ApiParam(value="The item name.", required=true) @PathParam(value="itemname") String itemName, @ApiParam(value="Time of the data to be stored. Will default to current time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="time") String time, @ApiParam(value="The state to store.", required=true) @QueryParam(value="state") String value) {
        return this.putItemState(serviceId, itemName, value, time);
    }

    private Date convertTime(String sTime) {
        DateTimeType dateTime = new DateTimeType(sTime);
        return Date.from(dateTime.getZonedDateTime().toInstant());
    }

    private Response getItemHistoryDTO(String serviceId, String itemName, String timeBegin, String timeEnd, int pageNumber, int pageLength, boolean boundary) {
        Iterable result;
        Date dateTimeBegin;
        long timerStart = System.currentTimeMillis();
        PersistenceService service = null;
        String effectiveServiceId = serviceId != null ? serviceId : this.persistenceServiceRegistry.getDefaultId();
        service = this.persistenceServiceRegistry.get(effectiveServiceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + effectiveServiceId));
        }
        if (!(service instanceof QueryablePersistenceService)) {
            this.logger.debug("Persistence service not queryable '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not queryable: " + effectiveServiceId));
        }
        QueryablePersistenceService qService = (QueryablePersistenceService)service;
        Date dateTimeEnd = dateTimeBegin = new Date();
        if (timeBegin != null) {
            dateTimeBegin = this.convertTime(timeBegin);
        }
        if (timeEnd != null) {
            dateTimeEnd = this.convertTime(timeEnd);
        }
        if (dateTimeEnd.getTime() == 0L) {
            dateTimeEnd = new Date();
        }
        if (dateTimeBegin.getTime() == 0L) {
            dateTimeBegin = new Date(dateTimeEnd.getTime() - 86400000L);
        }
        if (dateTimeBegin.getTime() >= dateTimeEnd.getTime()) {
            dateTimeBegin = new Date(dateTimeEnd.getTime() - 86400000L);
        }
        State state = null;
        Long quantity = 0L;
        ItemHistoryDTO dto = new ItemHistoryDTO();
        dto.name = itemName;
        FilterCriteria filter = new FilterCriteria();
        filter.setItemName(itemName);
        if (boundary) {
            filter.setEndDate(dateTimeBegin);
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            result = qService.query(filter);
            if (result != null && result.iterator().hasNext()) {
                dto.addData(Long.valueOf(dateTimeBegin.getTime()), ((HistoricItem)result.iterator().next()).getState());
                quantity = quantity + 1L;
            }
        }
        if (pageLength == 0) {
            filter.setPageNumber(0);
            filter.setPageSize(Integer.MAX_VALUE);
        } else {
            filter.setPageNumber(pageNumber);
            filter.setPageSize(pageLength);
        }
        filter.setBeginDate(dateTimeBegin);
        filter.setEndDate(dateTimeEnd);
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        result = qService.query(filter);
        if (result != null) {
            for (HistoricItem historicItem : result) {
                state = historicItem.getState();
                if (state instanceof OnOffType || state instanceof OpenClosedType) {
                    dto.addData(Long.valueOf(historicItem.getTimestamp().getTime()), state);
                }
                dto.addData(Long.valueOf(historicItem.getTimestamp().getTime()), state);
                quantity = quantity + 1L;
            }
        }
        if (boundary) {
            filter.setBeginDate(dateTimeEnd);
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            result = qService.query(filter);
            if (result != null && result.iterator().hasNext()) {
                dto.addData(Long.valueOf(dateTimeEnd.getTime()), ((HistoricItem)result.iterator().next()).getState());
                quantity = quantity + 1L;
            }
        }
        dto.datapoints = Long.toString(quantity);
        this.logger.debug("Persistence returned {} rows in {}ms", (Object)dto.datapoints, (Object)(System.currentTimeMillis() - timerStart));
        return JSONResponse.createResponse((Response.Status)Response.Status.OK, (Object)dto, (String)"");
    }

    private List<PersistenceServiceDTO> getPersistenceServiceList(Locale locale) {
        ArrayList<PersistenceServiceDTO> dtoList = new ArrayList<PersistenceServiceDTO>();
        for (PersistenceService service : this.persistenceServiceRegistry.getAll()) {
            PersistenceServiceDTO serviceDTO = new PersistenceServiceDTO();
            serviceDTO.id = service.getId();
            serviceDTO.label = service.getLabel(locale);
            serviceDTO.type = service instanceof ModifiablePersistenceService ? "Modifiable" : (service instanceof QueryablePersistenceService ? "Queryable" : "Standard");
            dtoList.add(serviceDTO);
        }
        return dtoList;
    }

    private Response getServiceItemList(String serviceId) {
        PersistenceService service = null;
        service = serviceId == null ? this.persistenceServiceRegistry.getDefault() : this.persistenceServiceRegistry.get(serviceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + serviceId));
        }
        if (!(service instanceof QueryablePersistenceService)) {
            this.logger.debug("Persistence service not queryable '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not queryable: " + serviceId));
        }
        QueryablePersistenceService qService = (QueryablePersistenceService)service;
        return JSONResponse.createResponse((Response.Status)Response.Status.OK, (Object)qService.getItemInfo(), (String)"");
    }

    private Response deletePersistenceItemData(String serviceId, String itemName, String timeBegin, String timeEnd) {
        if (serviceId == null || serviceId.length() == 0) {
            this.logger.debug("Persistence service must be specified for delete operations.");
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"Persistence service must be specified for delete operations.");
        }
        PersistenceService service = this.persistenceServiceRegistry.get(serviceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + serviceId));
        }
        if (!(service instanceof ModifiablePersistenceService)) {
            this.logger.warn("Persistence service not modifiable '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not modifiable: " + serviceId));
        }
        ModifiablePersistenceService mService = (ModifiablePersistenceService)service;
        if (timeBegin == null | timeEnd == null) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"The start and end time must be set");
        }
        Date dateTimeBegin = this.convertTime(timeBegin);
        Date dateTimeEnd = this.convertTime(timeEnd);
        if (dateTimeEnd.before(dateTimeBegin)) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"Start time must be earlier than end time");
        }
        FilterCriteria filter = new FilterCriteria();
        filter.setBeginDate(dateTimeBegin);
        filter.setEndDate(dateTimeEnd);
        filter.setItemName(itemName);
        try {
            mService.remove(filter);
        }
        catch (IllegalArgumentException e) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"Invalid filter parameters.");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Response putItemState(String serviceId, String itemName, String value, String time) {
        Item item;
        PersistenceService service = null;
        String effectiveServiceId = serviceId != null ? serviceId : this.persistenceServiceRegistry.getDefaultId();
        service = this.persistenceServiceRegistry.get(effectiveServiceId);
        if (service == null) {
            this.logger.warn("Persistence service not found '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + effectiveServiceId));
        }
        try {
            if (this.itemRegistry == null) {
                this.logger.warn("Item registry not set.");
                return JSONResponse.createErrorResponse((Response.Status)Response.Status.CONFLICT, (String)"Item registry not set.");
            }
            item = this.itemRegistry.getItem(itemName);
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Item not found '{}'.", (Object)itemName);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Item not found: " + itemName));
        }
        State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)value);
        if (state == null) {
            this.logger.warn("Can't persist item {} with invalid state '{}'.", (Object)itemName, (Object)value);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("State could not be parsed: " + value));
        }
        Date dateTime = null;
        if (time != null && time.length() != 0) {
            dateTime = this.convertTime(time);
        }
        if (dateTime == null || dateTime.getTime() == 0L) {
            this.logger.warn("Error with persistence store to {}. Time badly formatted {}.", (Object)itemName, (Object)time);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"Time badly formatted.");
        }
        if (!(service instanceof ModifiablePersistenceService)) {
            this.logger.warn("Persistence service not modifiable '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("Persistence service not modifiable: " + effectiveServiceId));
        }
        ModifiablePersistenceService mService = (ModifiablePersistenceService)service;
        mService.store(item, dateTime, state);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public boolean isSatisfied() {
        return this.itemRegistry != null && this.persistenceServiceRegistry != null;
    }
}

