/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.io.rest.sitemap.internal.PageChangeListener;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapSubscriptionService
implements ModelRepositoryChangeListener {
    private static final String SITEMAP_PAGE_SEPARATOR = "#";
    private static final String SITEMAP_SUFFIX = ".sitemap";
    private final Logger logger = LoggerFactory.getLogger(SitemapSubscriptionService.class);
    private ItemUIRegistry itemUIRegistry;
    private ModelRepository modelRepo;
    private List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, String> pageOfSubscription = new ConcurrentHashMap<String, String>();
    private Map<String, SitemapSubscriptionCallback> callbacks = new ConcurrentHashMap<String, SitemapSubscriptionCallback>();
    private Map<String, PageChangeListener> pageChangeListeners = new ConcurrentHashMap<String, PageChangeListener>();

    protected void activate() {
    }

    protected void deactivate() {
        this.pageOfSubscription.clear();
        this.callbacks.clear();
        for (PageChangeListener listener : this.pageChangeListeners.values()) {
            listener.dispose();
        }
        this.pageChangeListeners.clear();
    }

    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    protected void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    protected void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    protected void addModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
        this.modelRepo.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void removeModelRepository(ModelRepository modelRepo) {
        this.modelRepo.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepo = null;
    }

    public String createSubscription(SitemapSubscriptionCallback callback) {
        String subscriptionId = UUID.randomUUID().toString();
        this.callbacks.put(subscriptionId, callback);
        this.logger.debug("Created new subscription with id {}", (Object)subscriptionId);
        return subscriptionId;
    }

    public void removeSubscription(String subscriptionId) {
        PageChangeListener listener;
        this.callbacks.remove(subscriptionId);
        String sitemapPage = this.pageOfSubscription.remove(subscriptionId);
        if (sitemapPage != null && !this.pageOfSubscription.values().contains(sitemapPage) && (listener = this.pageChangeListeners.remove(sitemapPage)) != null) {
            listener.dispose();
        }
        this.logger.debug("Removed subscription with id {}", (Object)subscriptionId);
    }

    public boolean exists(String subscriptionId) {
        return this.callbacks.containsKey(subscriptionId);
    }

    public String getPageId(String subscriptionId) {
        return this.extractPageId(this.pageOfSubscription.get(subscriptionId));
    }

    public String getSitemapName(String subscriptionId) {
        return this.extractSitemapName(this.pageOfSubscription.get(subscriptionId));
    }

    private String extractSitemapName(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[0];
    }

    private String extractPageId(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[1];
    }

    public void setPageId(String subscriptionId, String sitemapName, String pageId) {
        SitemapSubscriptionCallback callback = this.callbacks.get(subscriptionId);
        if (callback != null) {
            String oldSitemapPage = this.pageOfSubscription.remove(subscriptionId);
            if (oldSitemapPage != null) {
                this.removeCallbackFromListener(oldSitemapPage, callback);
            }
        } else {
            throw new IllegalArgumentException("Subscription " + subscriptionId + " does not exist!");
        }
        this.addCallbackToListener(sitemapName, pageId, callback);
        this.pageOfSubscription.put(subscriptionId, this.getValue(sitemapName, pageId));
        this.logger.debug("Subscription {} changed to page {} of sitemap {}", new Object[]{subscriptionId, pageId, sitemapName});
    }

    private void addCallbackToListener(String sitemapName, String pageId, SitemapSubscriptionCallback callback) {
        PageChangeListener listener = this.pageChangeListeners.get(this.getValue(sitemapName, pageId));
        if (listener == null) {
            listener = new PageChangeListener(sitemapName, pageId, this.itemUIRegistry, this.collectWidgets(sitemapName, pageId));
            this.pageChangeListeners.put(this.getValue(sitemapName, pageId), listener);
        }
        if (listener != null) {
            listener.addCallback(callback);
        }
    }

    private EList<Widget> collectWidgets(String sitemapName, String pageId) {
        BasicEList widgets = new BasicEList();
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                widgets = this.itemUIRegistry.getChildren(sitemap);
            } else {
                Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget) {
                    widgets = this.itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                    widgets.add((Object)pageWidget);
                }
            }
        }
        return widgets;
    }

    private void removeCallbackFromListener(String sitemapPage, SitemapSubscriptionCallback callback) {
        PageChangeListener oldListener = this.pageChangeListeners.get(sitemapPage);
        if (oldListener != null) {
            oldListener.removeCallback(callback);
            if (!this.pageOfSubscription.values().contains(sitemapPage)) {
                oldListener.dispose();
                this.pageChangeListeners.remove(sitemapPage);
            }
        }
    }

    private String getValue(String sitemapName, String pageId) {
        return String.valueOf(sitemapName) + SITEMAP_PAGE_SEPARATOR + pageId;
    }

    private Sitemap getSitemap(String sitemapName) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapName);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    public void modelChanged(String modelName, EventType type) {
        if (type != EventType.MODIFIED || !modelName.endsWith(SITEMAP_SUFFIX)) {
            return;
        }
        String changedSitemapName = StringUtils.removeEnd((String)modelName, (String)SITEMAP_SUFFIX);
        for (Map.Entry<String, PageChangeListener> listenerEntry : this.pageChangeListeners.entrySet()) {
            String sitemapWithPage = listenerEntry.getKey();
            String sitemapName = this.extractSitemapName(sitemapWithPage);
            if (!sitemapName.equals(changedSitemapName)) continue;
            listenerEntry.getValue().sitemapContentChanged();
        }
    }

    public static interface SitemapSubscriptionCallback {
        public void onEvent(SitemapEvent var1);
    }
}

