/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONResponse {
    private final Logger logger = LoggerFactory.getLogger(JSONResponse.class);
    private static final JSONResponse INSTANCE = new JSONResponse();
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    static final String JSON_KEY_ERROR_MESSAGE = "message";
    static final String JSON_KEY_ERROR = "error";
    static final String JSON_KEY_HTTPCODE = "http-code";
    static final String JSON_KEY_ENTITY = "entity";

    private JSONResponse() {
    }

    public static Response createErrorResponse(Response.Status status, String errormessage) {
        return JSONResponse.createResponse(status, null, errormessage);
    }

    public static Response createResponse(Response.Status status, Object entity, String errormessage) {
        if (status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            return INSTANCE.createErrorResponse(status, entity, errormessage);
        }
        return INSTANCE.createResponse(status, entity);
    }

    private Response.ResponseBuilder responseBuilder(Response.Status status) {
        return Response.status((Response.Status)status).header("Content-Type", (Object)"application/json");
    }

    private JsonElement createErrorJson(String message, Response.Status status, Object entity, Exception ex) {
        JsonObject resultJson = new JsonObject();
        JsonObject errorJson = new JsonObject();
        resultJson.add(JSON_KEY_ERROR, (JsonElement)errorJson);
        errorJson.addProperty(JSON_KEY_ERROR_MESSAGE, message);
        if (status != null) {
            errorJson.addProperty(JSON_KEY_HTTPCODE, (Number)status.getStatusCode());
        }
        if (entity != null) {
            resultJson.add(JSON_KEY_ENTITY, this.gson.toJsonTree(entity));
        }
        if (ex != null) {
            JsonObject exceptionJson = new JsonObject();
            exceptionJson.addProperty("class", ex.getClass().getName());
            exceptionJson.addProperty(JSON_KEY_ERROR_MESSAGE, ex.getMessage());
            exceptionJson.addProperty("localized-message", ex.getLocalizedMessage());
            exceptionJson.addProperty("cause", ex.getCause() != null ? ex.getCause().getClass().getName() : null);
            errorJson.add("exception", (JsonElement)exceptionJson);
        }
        return resultJson;
    }

    private Response createErrorResponse(Response.Status status, Object entity, String errormessage) {
        Response.ResponseBuilder rp = this.responseBuilder(status);
        JsonElement errorJson = this.createErrorJson(errormessage, status, entity, null);
        rp.entity((Object)errorJson);
        return rp.build();
    }

    private Response createResponse(Response.Status status, Object entity) {
        Response.ResponseBuilder rp = this.responseBuilder(status);
        if (entity == null) {
            return rp.build();
        }
        PipedOutputStream out = new PipedOutputStream();
        try {
            PipedInputStream in = new PipedInputStream(out);
            rp.entity((Object)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Thread writerThread = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out)));){
                    if (entity != null) {
                        this.gson.toJson(entity, entity.getClass(), jsonWriter);
                        jsonWriter.flush();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonIOException | IOException e) {
                this.logger.error("Error streaming JSON through PipedInpuStream/PipedOutputStream: ", e);
            }
        });
        writerThread.setDaemon(true);
        writerThread.start();
        return rp.build();
    }

    @Provider
    public static class ExceptionMapper
    implements javax.ws.rs.ext.ExceptionMapper<Exception> {
        private final Logger logger = LoggerFactory.getLogger(ExceptionMapper.class);

        public Response toResponse(Exception e) {
            this.logger.debug("exception during REST Handling", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (e instanceof WebApplicationException) {
                status = (Response.Status)((WebApplicationException)e).getResponse().getStatusInfo();
            }
            JsonElement ret = INSTANCE.createErrorJson(e.getMessage(), status, null, e);
            return INSTANCE.responseBuilder(status).entity((Object)INSTANCE.gson.toJson(ret)).build();
        }
    }
}

