/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.io.rest.DTOMapper;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DTOMapperImpl
implements DTOMapper {
    private final Logger logger = LoggerFactory.getLogger(DTOMapper.class);

    @Override
    public <T> Stream<T> limitToFields(Stream<T> itemStream, String fields) {
        if (fields == null || fields.trim().isEmpty()) {
            return itemStream;
        }
        List fieldList = Stream.of(fields.split(",")).map(field -> field.trim()).collect(Collectors.toList());
        return itemStream.map(dto -> {
            Field[] fieldArray = dto.getClass().getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!fieldList.contains(field.getName())) {
                    try {
                        field.set(dto, null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        this.logger.warn("Field '{}' could not be eliminated: {}", (Object)field.getName(), (Object)e.getMessage());
                    }
                }
                ++n2;
            }
            return dto;
        });
    }
}

