/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal;

import java.util.Locale;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTActivator
implements BundleActivator {
    private final Logger logger = LoggerFactory.getLogger(RESTActivator.class);
    private static BundleContext context;
    private static LocaleProvider localeProvider;
    private ServiceTracker<LocaleProvider, LocaleProvider> localeProviderTracker;

    public void start(BundleContext bc) throws Exception {
        context = bc;
        this.localeProviderTracker = new ServiceTracker(context, LocaleProvider.class.getName(), (ServiceTrackerCustomizer)new LocaleProviderServiceTrackerCustomizer(context));
        this.localeProviderTracker.open();
        this.logger.debug("REST API has been started.");
    }

    public void stop(BundleContext bc) throws Exception {
        context = null;
        this.localeProviderTracker.close();
        this.logger.debug("REST API has been stopped.");
    }

    public static BundleContext getContext() {
        return context;
    }

    public static Locale getLocale() {
        LocaleProvider provider = localeProvider;
        if (provider != null) {
            return provider.getLocale();
        }
        LoggerFactory.getLogger(RESTActivator.class).error("There should ALWAYS a local provider available, as it is provided by the core.");
        return Locale.US;
    }

    private class LocaleProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LocaleProvider, LocaleProvider> {
        private final BundleContext context;

        public LocaleProviderServiceTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public LocaleProvider addingService(ServiceReference<LocaleProvider> reference) {
            RESTActivator.localeProvider = (LocaleProvider)this.context.getService(reference);
            return localeProvider;
        }

        public void modifiedService(ServiceReference<LocaleProvider> reference, LocaleProvider service) {
        }

        public void removedService(ServiceReference<LocaleProvider> reference, LocaleProvider service) {
            RESTActivator.localeProvider = null;
        }
    }
}

