/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.item.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;
import org.eclipse.smarthome.model.items.ItemModel;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupFunction;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericItemProvider
extends AbstractProvider<Item>
implements ModelRepositoryChangeListener,
ItemProvider,
StateDescriptionProvider {
    private final Logger logger = LoggerFactory.getLogger(GenericItemProvider.class);
    private final Map<String, BindingConfigReader> bindingConfigReaders = new HashMap<String, BindingConfigReader>();
    private ModelRepository modelRepository = null;
    private final Map<String, Collection<Item>> itemsMap = new ConcurrentHashMap<String, Collection<Item>>();
    private final Collection<ItemFactory> itemFactorys = new ArrayList<ItemFactory>();
    private final Map<String, StateDescription> stateDescriptions = new ConcurrentHashMap<String, StateDescription>();
    private Integer rank;

    protected void activate(Map<String, Object> properties) {
        Object serviceRanking = properties.get("service.ranking");
        this.rank = serviceRanking instanceof Integer ? (Integer)serviceRanking : Integer.valueOf(0);
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        for (String modelName : modelRepository.getAllModelNamesOfType("items")) {
            this.modelChanged(modelName, EventType.ADDED);
        }
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void addItemFactory(ItemFactory factory) {
        this.itemFactorys.add(factory);
        this.dispatchBindingsPerItemType(null, factory.getSupportedItemTypes());
    }

    public void removeItemFactory(ItemFactory factory) {
        this.itemFactorys.remove(factory);
    }

    public void addBindingConfigReader(BindingConfigReader reader) {
        if (!this.bindingConfigReaders.containsKey(reader.getBindingType())) {
            this.bindingConfigReaders.put(reader.getBindingType(), reader);
            this.dispatchBindingsPerType(reader, new String[]{reader.getBindingType()});
        } else {
            this.logger.warn("Attempted to register a second BindingConfigReader of type '{}'. The primaraly reader will remain active!", (Object)reader.getBindingType());
        }
    }

    public void removeBindingConfigReader(BindingConfigReader reader) {
        if (this.bindingConfigReaders.get(reader.getBindingType()).equals(reader)) {
            this.bindingConfigReaders.remove(reader.getBindingType());
        }
    }

    public Collection<Item> getAll() {
        ArrayList<Item> items = new ArrayList<Item>();
        this.stateDescriptions.clear();
        for (String name : this.modelRepository.getAllModelNamesOfType("items")) {
            items.addAll(this.getItemsFromModel(name));
        }
        return items;
    }

    private Collection<Item> getItemsFromModel(String modelName) {
        ItemModel model;
        this.logger.debug("Read items from model '{}'", (Object)modelName);
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.modelRepository != null && (model = (ItemModel)this.modelRepository.getModel(modelName)) != null) {
            for (ModelItem modelItem : model.getItems()) {
                Item item = this.createItemFromModelItem(modelItem);
                if (item == null) continue;
                for (String groupName : modelItem.getGroups()) {
                    ((GenericItem)item).addGroupName(groupName);
                }
                items.add(item);
            }
        }
        return items;
    }

    private void processBindingConfigsFromModel(String modelName, EventType type) {
        this.logger.debug("Processing binding configs for items from model '{}'", (Object)modelName);
        if (this.modelRepository != null) {
            ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
            if (model == null) {
                return;
            }
            for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
                reader.startConfigurationUpdate(modelName);
            }
            if (!EventType.REMOVED.equals((Object)type)) {
                for (ModelItem modelItem : model.getItems()) {
                    Item item = this.createItemFromModelItem(modelItem);
                    if (item == null) continue;
                    this.internalDispatchBindings(modelName, item, modelItem.getBindings());
                }
            }
            for (BindingConfigReader reader : this.bindingConfigReaders.values()) {
                reader.stopConfigurationUpdate(modelName);
            }
        }
    }

    private Item createItemFromModelItem(ModelItem modelItem) {
        GenericItem item = null;
        if (modelItem instanceof ModelGroupItem) {
            ModelGroupItem modelGroupItem = (ModelGroupItem)modelItem;
            String baseItemType = modelGroupItem.getType();
            GenericItem baseItem = this.createItemOfType(baseItemType, modelGroupItem.getName());
            if (baseItem != null) {
                ModelGroupFunction function = modelGroupItem.getFunction();
                item = this.applyGroupFunction(baseItem, modelGroupItem, function);
            } else {
                item = new GroupItem(modelGroupItem.getName());
            }
        } else {
            ModelNormalItem normalItem = (ModelNormalItem)modelItem;
            String itemName = normalItem.getName();
            item = this.createItemOfType(normalItem.getType(), itemName);
        }
        if (item != null) {
            String label = modelItem.getLabel();
            String format = StringUtils.substringBetween((String)label, (String)"[", (String)"]");
            if (format != null) {
                label = StringUtils.substringBefore((String)label, (String)"[").trim();
                this.stateDescriptions.put(modelItem.getName(), new StateDescription(null, null, null, format, false, null));
            }
            item.setLabel(label);
            item.setCategory(modelItem.getIcon());
            this.assignTags(modelItem, item);
            return item;
        }
        return null;
    }

    private void assignTags(ModelItem modelItem, GenericItem item) {
        EList<String> tags = modelItem.getTags();
        for (String tag : tags) {
            item.addTag(tag);
        }
    }

    private GroupItem applyGroupFunction(GenericItem baseItem, ModelGroupItem modelGroupItem, ModelGroupFunction function) {
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getName();
        dto.params = (String[])modelGroupItem.getArgs().toArray((Object[])new String[modelGroupItem.getArgs().size()]);
        GroupFunction groupFunction = ItemDTOMapper.mapFunction((Item)baseItem, (GroupFunctionDTO)dto);
        return new GroupItem(modelGroupItem.getName(), baseItem, groupFunction);
    }

    private void dispatchBindingsPerItemType(BindingConfigReader reader, String[] itemTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        String[] stringArray = itemTypes;
                        int n = itemTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Item item;
                            String itemType = stringArray[n2];
                            if (itemType.equals(modelItem.getType()) && (item = this.createItemFromModelItem(modelItem)) != null) {
                                this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
                this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            this.logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void dispatchBindingsPerType(BindingConfigReader reader, String[] bindingTypes) {
        if (this.modelRepository != null) {
            for (String modelName : this.modelRepository.getAllModelNamesOfType("items")) {
                ItemModel model = (ItemModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    for (ModelItem modelItem : model.getItems()) {
                        for (ModelBinding modelBinding : modelItem.getBindings()) {
                            String[] stringArray = bindingTypes;
                            int n = bindingTypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Item item;
                                String bindingType = stringArray[n2];
                                if (bindingType.equals(modelBinding.getType()) && (item = this.createItemFromModelItem(modelItem)) != null) {
                                    this.internalDispatchBindings(reader, modelName, item, modelItem.getBindings());
                                }
                                ++n2;
                            }
                        }
                    }
                    continue;
                }
                this.logger.debug("Model repository returned NULL for model named '{}'", (Object)modelName);
            }
        } else {
            this.logger.warn("ModelRepository is NULL > dispatch bindings aborted!");
        }
    }

    private void internalDispatchBindings(String modelName, Item item, EList<ModelBinding> bindings) {
        this.internalDispatchBindings(null, modelName, item, bindings);
    }

    private void internalDispatchBindings(BindingConfigReader reader, String modelName, Item item, EList<ModelBinding> bindings) {
        for (ModelBinding binding : bindings) {
            String bindingType = binding.getType();
            String config = binding.getConfiguration();
            Configuration configuration = new Configuration();
            binding.getProperties().forEach(p -> {
                Object object = configuration.put(p.getKey(), p.getValue());
            });
            BindingConfigReader localReader = reader;
            if (reader == null) {
                this.logger.trace("Given binding config reader is null > query cache to find appropriate reader!");
                localReader = this.bindingConfigReaders.get(bindingType);
            } else {
                if (!localReader.getBindingType().equals(binding.getType())) {
                    this.logger.trace("The Readers' binding type '{}' and the Bindings' type '{}' doesn't match > continue processing next binding.", (Object)localReader.getBindingType(), (Object)binding.getType());
                    continue;
                }
                this.logger.debug("Start processing binding configuration of Item '{}' with '{}' reader.", (Object)item, (Object)localReader.getClass().getSimpleName());
            }
            if (localReader != null) {
                try {
                    localReader.validateItemType(item.getType(), config);
                    localReader.processBindingConfiguration(modelName, item.getType(), item.getName(), config, configuration);
                }
                catch (BindingConfigParseException e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                catch (Exception e) {
                    this.logger.error("Binding configuration of type '{}' of item '{}' could not be parsed correctly.", new Object[]{bindingType, item.getName(), e});
                }
                continue;
            }
            this.logger.trace("Couldn't find config reader for binding type '{}' > parsing binding configuration of Item '{}' aborted!", (Object)bindingType, (Object)item);
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith("items")) {
            switch (type) {
                case ADDED: 
                case MODIFIED: {
                    Map<String, Item> oldItems = this.toItemMap(this.itemsMap.get(modelName));
                    Map<String, Item> newItems = this.toItemMap(this.getItemsFromModel(modelName));
                    this.itemsMap.put(modelName, newItems.values());
                    for (Item newItem : newItems.values()) {
                        if (oldItems.containsKey(newItem.getName())) {
                            Item oldItem = oldItems.get(newItem.getName());
                            if (!this.hasItemChanged(oldItem, newItem)) continue;
                            this.notifyListenersAboutUpdatedElement(oldItem, newItem);
                            continue;
                        }
                        this.notifyListenersAboutAddedElement(newItem);
                    }
                    this.processBindingConfigsFromModel(modelName, type);
                    for (Item oldItem : oldItems.values()) {
                        if (newItems.containsKey(oldItem.getName())) continue;
                        this.notifyListenersAboutRemovedElement(oldItem);
                    }
                    break;
                }
                case REMOVED: {
                    this.processBindingConfigsFromModel(modelName, type);
                    Collection<Item> itemsFromModel = this.getItemsFromModel(modelName);
                    this.itemsMap.remove(modelName);
                    for (Item item : itemsFromModel) {
                        this.notifyListenersAboutRemovedElement(item);
                    }
                    break;
                }
            }
        }
    }

    private boolean hasItemChanged(Item item1, Item item2) {
        return !Objects.equals(item1.getClass(), item2.getClass()) || !Objects.equals(item1.getName(), item2.getName()) || !Objects.equals(item1.getCategory(), item2.getCategory()) || !Objects.equals(item1.getGroupNames(), item2.getGroupNames()) || !Objects.equals(item1.getLabel(), item2.getLabel()) || !Objects.equals(item1.getTags(), item2.getTags()) || !Objects.equals(item1.getType(), item2.getType());
    }

    private Map<String, Item> toItemMap(Collection<Item> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Item> ret = new LinkedHashMap<String, Item>();
        for (Item item : items) {
            ret.put(item.getName(), item);
        }
        return ret;
    }

    private GenericItem createItemOfType(String itemType, String itemName) {
        if (itemType == null) {
            return null;
        }
        for (ItemFactory factory : this.itemFactorys) {
            GenericItem item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            this.logger.trace("Created item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return item;
        }
        this.logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    public StateDescription getStateDescription(String itemName, Locale locale) {
        return this.stateDescriptions.get(itemName);
    }
}

