/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.chart.defaultchartprovider;

import java.awt.Color;
import java.awt.Font;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartTheme;

public class ChartThemeDark
implements ChartTheme {
    private static final String THEME_NAME = "dark";
    private Color[] LINECOLORS = new Color[]{new Color(244, 67, 54), new Color(76, 175, 80), new Color(63, 81, 181), new Color(156, 39, 176), new Color(255, 152, 0), new Color(0, 188, 212).darker(), new Color(233, 30, 99).darker(), Color.WHITE, new Color(255, 235, 59)};
    private static final String FONT_NAME = "SansSerif";

    @Override
    public String getThemeName() {
        return THEME_NAME;
    }

    @Override
    public Color getPlotBackgroundColor() {
        return new Color(40, 40, 40);
    }

    @Override
    public Color getPlotGridLinesColor() {
        return Color.WHITE.darker();
    }

    @Override
    public double getPlotGridLinesWidth(int dpi) {
        return Math.max(1.0, (double)dpi / 64.0);
    }

    @Override
    public double getPlotGridLinesDash(int dpi) {
        return Math.max(3.0, (double)dpi / 32.0);
    }

    @Override
    public Color getLegendBackgroundColor() {
        return new Color(30, 30, 30, 160);
    }

    @Override
    public Color getChartBackgroundColor() {
        return new Color(48, 48, 48);
    }

    @Override
    public Color getChartFontColor() {
        return new Color(255, 255, 255, 255);
    }

    @Override
    public Color getLineColor(int series) {
        return this.LINECOLORS[series % this.LINECOLORS.length];
    }

    @Override
    public double getLineWidth(int dpi) {
        return Math.max(1.0, (double)dpi / 64.0);
    }

    @Override
    public Color getAxisTickLabelsColor() {
        return this.getChartFontColor();
    }

    @Override
    public Font getAxisTickLabelsFont(int dpi) {
        int fontsize = (int)Math.max(8L, Math.round((double)dpi / 8.5));
        return new Font(FONT_NAME, 0, fontsize);
    }

    @Override
    public Font getLegendFont(int dpi) {
        int fontsize = (int)Math.max(8L, Math.round((double)dpi / 9.6));
        return new Font(FONT_NAME, 0, fontsize);
    }

    @Override
    public int getChartPadding(int dpi) {
        return (int)Math.max(5L, Math.round((double)dpi / 19.0));
    }

    @Override
    public int getLegendSeriesLineLength(int dpi) {
        return (int)Math.max(10L, Math.round((double)dpi / 12.0));
    }
}

