/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.auth.oauth2client.internal.cipher;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.auth.client.oauth2.StorageCipher;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component
public class SymmetricKeyCipher
implements StorageCipher {
    public static final String CIPHER_ID = "SymmetricKeyCipher";
    public static final String PID = "SymmetricKeyCipher";
    private final Logger logger = LoggerFactory.getLogger(SymmetricKeyCipher.class);
    private static final String ENCRYPTION_ALGO = "AES";
    private static final String ENCRYPTION_ALGO_MODE_WITH_PADDING = "AES/CBC/PKCS5Padding";
    private static final String PROPERTY_KEY_ENCRYPTION_KEY_BASE64 = "ENCRYPTION_KEY";
    private static final int ENCRYPTION_KEY_SIZE_BITS = 128;
    private static final int IV_BYTE_SIZE = 16;
    @NonNullByDefault(value={})
    private ConfigurationAdmin configurationAdmin;
    @NonNullByDefault(value={})
    private SecretKey encryptionKey;
    private final SecureRandom random = new SecureRandom();

    @Activate
    public void activate() throws NoSuchAlgorithmException, IOException {
        this.encryptionKey = this.getOrGenerateEncryptionKey();
    }

    public String getUniqueCipherId() {
        return "SymmetricKeyCipher";
    }

    public @Nullable String encrypt(@Nullable String plainText) throws GeneralSecurityException {
        if (plainText == null) {
            return null;
        }
        byte[] iv = new byte[16];
        this.random.nextBytes(iv);
        Cipher cipherEnc = Cipher.getInstance(ENCRYPTION_ALGO_MODE_WITH_PADDING);
        cipherEnc.init(1, (Key)this.encryptionKey, new IvParameterSpec(iv));
        byte[] encryptedBytes = cipherEnc.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedBytesWithIV = new byte[encryptedBytes.length + 16];
        System.arraycopy(iv, 0, encryptedBytesWithIV, 0, 16);
        System.arraycopy(encryptedBytes, 0, encryptedBytesWithIV, 16, encryptedBytes.length);
        String encryptedBase64String = Base64.getEncoder().encodeToString(encryptedBytesWithIV);
        return encryptedBase64String;
    }

    public @Nullable String decrypt(@Nullable String base64CipherText) throws GeneralSecurityException {
        if (base64CipherText == null) {
            return null;
        }
        byte[] decodedCipherTextWithIV = Base64.getDecoder().decode(base64CipherText);
        byte[] iv = new byte[16];
        System.arraycopy(decodedCipherTextWithIV, 0, iv, 0, 16);
        byte[] cipherTextBytes = new byte[decodedCipherTextWithIV.length - 16];
        System.arraycopy(decodedCipherTextWithIV, 16, cipherTextBytes, 0, cipherTextBytes.length);
        Cipher cipherDec = Cipher.getInstance(ENCRYPTION_ALGO_MODE_WITH_PADDING);
        cipherDec.init(2, (Key)this.encryptionKey, new IvParameterSpec(iv));
        byte[] decryptedBytes = cipherDec.doFinal(cipherTextBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    private static SecretKey generateEncryptionKey() throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance(ENCRYPTION_ALGO);
        keygen.init(128);
        SecretKey secretKey = keygen.generateKey();
        return secretKey;
    }

    private SecretKey getOrGenerateEncryptionKey() throws NoSuchAlgorithmException, IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration("SymmetricKeyCipher");
        String encryptionKeyInBase64 = null;
        Hashtable<String, String> properties = configuration.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if (((Dictionary)properties).get(PROPERTY_KEY_ENCRYPTION_KEY_BASE64) == null) {
            this.encryptionKey = SymmetricKeyCipher.generateEncryptionKey();
            encryptionKeyInBase64 = new String(Base64.getEncoder().encode(this.encryptionKey.getEncoded()));
            ((Dictionary)properties).put(PROPERTY_KEY_ENCRYPTION_KEY_BASE64, encryptionKeyInBase64);
            configuration.update(properties);
            this.logger.debug("Encryption key generated");
        } else {
            encryptionKeyInBase64 = (String)((Dictionary)properties).get(PROPERTY_KEY_ENCRYPTION_KEY_BASE64);
            byte[] encKeyBytes = Base64.getDecoder().decode(encryptionKeyInBase64);
            this.encryptionKey = new SecretKeySpec(encKeyBytes, 0, 16, ENCRYPTION_ALGO);
            this.logger.debug("Encryption key loaded");
        }
        return this.encryptionKey;
    }

    @Reference
    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void unsetConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

