/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.osgi.service.component.annotations.Component;

@Component(service={ModuleTypeRegistry.class}, immediate=true)
public class ModuleTypeRegistryImpl
extends AbstractRegistry<ModuleType, String, ModuleTypeProvider>
implements ModuleTypeRegistry {
    public ModuleTypeRegistryImpl() {
        super(ModuleTypeProvider.class);
    }

    protected void addProvider(Provider<ModuleType> provider) {
        if (provider instanceof ModuleTypeProvider) {
            super.addProvider(provider);
        }
    }

    public ModuleType get(String typeUID) {
        return this.get(typeUID, null);
    }

    public <T extends ModuleType> T get(String moduleTypeUID, Locale locale) {
        Map.Entry mType = this.getValueAndProvider(moduleTypeUID);
        if (mType == null) {
            return null;
        }
        ModuleType mt = locale == null ? (ModuleType)mType.getValue() : ((ModuleTypeProvider)mType.getKey()).getModuleType(((ModuleType)mType.getValue()).getUID(), locale);
        return (T)this.createCopy(mt);
    }

    public <T extends ModuleType> Collection<T> getByTag(String moduleTypeTag) {
        return this.getByTag(moduleTypeTag, null);
    }

    public <T extends ModuleType> Collection<T> getByTag(String moduleTypeTag, Locale locale) {
        ArrayList result = new ArrayList(20);
        this.forEach((provider, mType) -> {
            ModuleType mt = locale == null ? mType : ((ModuleTypeProvider)provider).getModuleType(mType.getUID(), locale);
            Set tags = mt.getTags();
            if (moduleTypeTag == null) {
                result.add(this.createCopy(mt));
            } else if (tags.contains(moduleTypeTag)) {
                result.add(this.createCopy(mt));
            }
        });
        return result;
    }

    public <T extends ModuleType> Collection<T> getByTags(String ... tags) {
        return this.getByTags((Locale)null, tags);
    }

    public <T extends ModuleType> Collection<T> getByTags(Locale locale, String ... tags) {
        HashSet<String> tagSet = tags != null ? new HashSet<String>(Arrays.asList(tags)) : null;
        ArrayList result = new ArrayList(20);
        this.forEach((provider, mType) -> {
            ModuleType mt;
            ModuleType moduleType = mt = locale == null ? mType : ((ModuleTypeProvider)provider).getModuleType(mType.getUID(), locale);
            if (tagSet == null) {
                result.add(this.createCopy(mt));
            } else if (mt.getTags().containsAll(tagSet)) {
                result.add(this.createCopy(mt));
            }
        });
        return result;
    }

    public Collection<TriggerType> getTriggers(Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<TriggerType> triggerTypes = new ArrayList<TriggerType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof TriggerType)) continue;
            triggerTypes.add((TriggerType)mt);
        }
        return triggerTypes;
    }

    public Collection<TriggerType> getTriggers(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<TriggerType> triggerTypes = new ArrayList<TriggerType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof TriggerType)) continue;
            triggerTypes.add((TriggerType)mt);
        }
        return triggerTypes;
    }

    public Collection<ConditionType> getConditions(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<ConditionType> conditionTypes = new ArrayList<ConditionType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof ConditionType)) continue;
            conditionTypes.add((ConditionType)mt);
        }
        return conditionTypes;
    }

    public Collection<ConditionType> getConditions(Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<ConditionType> conditionTypes = new ArrayList<ConditionType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof ConditionType)) continue;
            conditionTypes.add((ConditionType)mt);
        }
        return conditionTypes;
    }

    public Collection<ActionType> getActions(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof ActionType)) continue;
            actionTypes.add((ActionType)mt);
        }
        return actionTypes;
    }

    public Collection<ActionType> getActions(Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (ModuleType mt : moduleTypes) {
            if (!(mt instanceof ActionType)) continue;
            actionTypes.add((ActionType)mt);
        }
        return actionTypes;
    }

    private ModuleType createCopy(ModuleType mType) {
        TriggerType result;
        if (mType == null) {
            return null;
        }
        if (mType instanceof CompositeTriggerType) {
            CompositeTriggerType m = (CompositeTriggerType)mType;
            result = new CompositeTriggerType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs(), new ArrayList(m.getChildren()));
        } else if (mType instanceof TriggerType) {
            TriggerType m = (TriggerType)mType;
            result = new TriggerType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs());
        } else if (mType instanceof CompositeConditionType) {
            CompositeConditionType m = (CompositeConditionType)mType;
            result = new CompositeConditionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), new ArrayList(m.getChildren()));
        } else if (mType instanceof ConditionType) {
            ConditionType m = (ConditionType)mType;
            result = new ConditionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs());
        } else if (mType instanceof CompositeActionType) {
            CompositeActionType m = (CompositeActionType)mType;
            result = new CompositeActionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs(), new ArrayList(m.getChildren()));
        } else if (mType instanceof ActionType) {
            ActionType m = (ActionType)mType;
            result = new ActionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs());
        } else {
            throw new IllegalArgumentException("Invalid template type:" + mType);
        }
        return result;
    }
}

