/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.types.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCommandTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    private final Logger logger = LoggerFactory.getLogger(ItemCommandTriggerHandler.class);
    private final String itemName;
    private final String command;
    private final String topic;
    private final Set<String> types;
    private final BundleContext bundleContext;
    public static final String MODULE_TYPE_ID = "core.ItemCommandTrigger";
    private static final String CFG_ITEMNAME = "itemName";
    private static final String CFG_COMMAND = "command";
    private ServiceRegistration eventSubscriberRegistration;

    public ItemCommandTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.itemName = (String)module.getConfiguration().get(CFG_ITEMNAME);
        this.command = (String)module.getConfiguration().get(CFG_COMMAND);
        this.types = Collections.singleton(ItemCommandEvent.TYPE);
        this.bundleContext = bundleContext;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        this.topic = "smarthome/items/" + this.itemName + "/command";
        ((Dictionary)properties).put("event.topics", this.topic);
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, properties);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public EventFilter getEventFilter() {
        return this;
    }

    public void receive(Event event) {
        if (this.callback != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (event instanceof ItemCommandEvent) {
                Command command = ((ItemCommandEvent)event).getItemCommand();
                if (this.command == null || this.command.equals(command.toFullString())) {
                    values.put(CFG_COMMAND, command);
                    values.put("event", event);
                    ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, values);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public boolean apply(Event event) {
        this.logger.trace("->FILTER: {}:{}", (Object)event.getTopic(), (Object)this.itemName);
        return event.getTopic().equals(this.topic);
    }
}

