/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import org.eclipse.smarthome.automation.ModuleHandlerCallback;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.core.scheduler.CronScheduler;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCronTriggerHandler
extends BaseTriggerModuleHandler
implements SchedulerRunnable {
    private final Logger logger = LoggerFactory.getLogger(GenericCronTriggerHandler.class);
    public static final String MODULE_TYPE_ID = "timer.GenericCronTrigger";
    public static final String CALLBACK_CONTEXT_NAME = "CALLBACK";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_CRON_EXPRESSION = "cronExpression";
    private final CronScheduler scheduler;
    private final String expression;
    private ScheduledCompletableFuture<?> schedule;

    public GenericCronTriggerHandler(Trigger module, CronScheduler scheduler) {
        super(module);
        this.scheduler = scheduler;
        this.expression = (String)module.getConfiguration().get(CFG_CRON_EXPRESSION);
    }

    public synchronized void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
        this.scheduleJob();
    }

    private void scheduleJob() {
        this.schedule = this.scheduler.schedule((SchedulerRunnable)this, this.expression);
        this.logger.debug("Scheduled cron job '{}' for trigger '{}'.", ((Trigger)this.module).getConfiguration().get(CFG_CRON_EXPRESSION), (Object)((Trigger)this.module).getId());
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.schedule != null) {
            this.schedule.cancel(true);
            this.logger.debug("cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        }
    }

    public void run() {
        ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, null);
    }
}

