/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

public class ModuleTypeI18nUtil {
    public static final String MODULE_TYPE = "module-type";

    public static String getLocalizedModuleTypeLabel(TranslationProvider i18nProvider, Bundle bundle, String moduleTypeUID, String defaultLabel, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> ModuleTypeI18nUtil.inferModuleTypeKey(moduleTypeUID, "label"));
        return i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public static String getLocalizedModuleTypeDescription(TranslationProvider i18nProvider, Bundle bundle, String moduleTypeUID, String defaultDescription, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> ModuleTypeI18nUtil.inferModuleTypeKey(moduleTypeUID, "description"));
        return i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public static List<Input> getLocalizedInputs(TranslationProvider i18nProvider, List<Input> inputs, Bundle bundle, String uid, Locale locale) {
        ArrayList<Input> linputs = new ArrayList<Input>();
        if (inputs != null) {
            for (Input input : inputs) {
                String inputName = input.getName();
                String ilabel = ModuleTypeI18nUtil.getInputLabel(i18nProvider, bundle, uid, inputName, input.getLabel(), locale);
                String idescription = ModuleTypeI18nUtil.getInputDescription(i18nProvider, bundle, uid, inputName, input.getDescription(), locale);
                linputs.add(new Input(inputName, input.getType(), ilabel, idescription, input.getTags(), input.isRequired(), input.getReference(), input.getDefaultValue()));
            }
        }
        return linputs;
    }

    public static List<Output> getLocalizedOutputs(TranslationProvider i18nProvider, List<Output> outputs, Bundle bundle, String uid, Locale locale) {
        ArrayList<Output> loutputs = new ArrayList<Output>();
        if (outputs != null) {
            for (Output output : outputs) {
                String outputName = output.getName();
                String olabel = ModuleTypeI18nUtil.getOutputLabel(i18nProvider, bundle, uid, outputName, output.getLabel(), locale);
                String odescription = ModuleTypeI18nUtil.getOutputDescription(i18nProvider, bundle, uid, outputName, output.getDescription(), locale);
                loutputs.add(new Output(outputName, output.getType(), olabel, odescription, output.getTags(), output.getReference(), output.getDefaultValue()));
            }
        }
        return loutputs;
    }

    private static String getInputLabel(TranslationProvider i18nProvider, Bundle bundle, String moduleTypeUID, String inputName, String defaultLabel, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> ModuleTypeI18nUtil.inferInputKey(moduleTypeUID, inputName, "label"));
        return i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private static String getInputDescription(TranslationProvider i18nProvider, Bundle bundle, String moduleTypeUID, String inputName, String defaultDescription, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> ModuleTypeI18nUtil.inferInputKey(moduleTypeUID, inputName, "description"));
        return i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private static String getOutputLabel(TranslationProvider i18nProvider, Bundle bundle, String ruleTemplateUID, String outputName, String defaultLabel, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> ModuleTypeI18nUtil.inferOutputKey(ruleTemplateUID, outputName, "label"));
        return i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public static String getOutputDescription(TranslationProvider i18nProvider, Bundle bundle, String moduleTypeUID, String outputName, String defaultDescription, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> ModuleTypeI18nUtil.inferOutputKey(moduleTypeUID, outputName, "description"));
        return i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private static String inferModuleTypeKey(String moduleTypeUID, String lastSegment) {
        return "module-type." + moduleTypeUID + "." + lastSegment;
    }

    private static String inferInputKey(String moduleTypeUID, String inputName, String lastSegment) {
        return "module-type.input." + moduleTypeUID + ".name." + inputName + "." + lastSegment;
    }

    private static String inferOutputKey(String moduleTypeUID, String outputName, String lastSegment) {
        return "module-type.output." + moduleTypeUID + ".name." + outputName + "." + lastSegment;
    }
}

