/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.core.dto.RuleTemplateDTOMapper;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.io.rest.LocaleService;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Path(value="templates")
@Api(value="templates")
@Component
public class TemplateResource
implements RESTResource {
    private TemplateRegistry<RuleTemplate> templateRegistry;
    private LocaleService localeService;
    @Context
    private UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    protected void unsetTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        this.templateRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLocaleService(LocaleService localeService) {
        this.localeService = localeService;
    }

    protected void unsetLocaleService(LocaleService localeService) {
        this.localeService = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available templates.", response=Template.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Template.class, responseContainer="Collection")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = this.localeService.getLocale(language);
        Collection result = this.templateRegistry.getAll(locale).stream().map(template -> RuleTemplateDTOMapper.map((RuleTemplate)template)).collect(Collectors.toList());
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/{templateUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a template corresponding to the given UID.", response=Template.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Template.class), @ApiResponse(code=404, message="Template corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="templateUID") @ApiParam(value="templateUID", required=true) String templateUID) {
        Locale locale = this.localeService.getLocale(language);
        RuleTemplate template = (RuleTemplate)this.templateRegistry.get(templateUID, locale);
        if (template != null) {
            return Response.ok((Object)RuleTemplateDTOMapper.map((RuleTemplate)template)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public boolean isSatisfied() {
        return this.templateRegistry != null && this.localeService != null;
    }
}

