/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;

public class EventParser
extends CommonRpcParser<Object[], HmDatapointInfo> {
    private Object value;

    @Override
    public HmDatapointInfo parse(Object[] message) throws IOException {
        String address;
        Integer channel = 0;
        String addressWithChannel = this.toString(message[1]);
        if ("".equals(addressWithChannel)) {
            address = "GWE00000000";
            channel = HmChannel.CHANNEL_NUMBER_VARIABLE;
        } else {
            String[] configParts = StringUtils.trimToEmpty((String)addressWithChannel).split(":");
            address = this.getSanitizedAddress(configParts[0]);
            if (configParts.length > 1) {
                channel = NumberUtils.createInteger((String)configParts[1]);
            }
        }
        String name = this.toString(message[2]);
        this.value = message[3];
        return new HmDatapointInfo(address, HmParamsetType.VALUES, channel, name);
    }

    public Object getValue() {
        return this.value;
    }
}

