/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class DisplayTextVirtualDatapoint
extends AbstractVirtualDatapointHandler {
    private static final String DATAPOINT_NAME_DISPLAY_LINE = "DISPLAY_LINE_";
    private static final String DATAPOINT_NAME_DISPLAY_COLOR = "DISPLAY_COLOR_";
    private static final String DATAPOINT_NAME_DISPLAY_ICON = "DISPLAY_ICON_";
    private static final String DATAPOINT_NAME_DISPLAY_LED = "DISPLAY_LED";
    private static final String DATAPOINT_NAME_DISPLAY_BEEPER = "DISPLAY_BEEPER";
    private static final String DATAPOINT_NAME_DISPLAY_BEEPCOUNT = "DISPLAY_BEEPCOUNT";
    private static final String DATAPOINT_NAME_DISPLAY_BEEPINTERVAL = "DISPLAY_BEEPINTERVAL";
    private static final String DATAPOINT_NAME_DISPLAY_SUBMIT = "DISPLAY_SUBMIT";
    private static final String START = "0x02";
    private static final String STOP = "0x03";
    private static final String LINE = "0x12";
    private static final String COLOR = "0x11";
    private static final String LF = "0x0a";
    private static final String ICON = "0x13";
    private static final String BEEPER_START = "0x14";
    private static final String BEEPER_END = "0x1c";
    private static final String BEEPCOUNT_END = "0x1D";
    private static final String BEEPINTERVAL_END = "0x16";
    private static Map<String, String> replaceMap = new HashMap<String, String>();

    static {
        replaceMap.put("d6", "23");
        replaceMap.put("dc", "24");
        replaceMap.put("3d", "27");
        replaceMap.put("c4", "5b");
        replaceMap.put("df", "5f");
        replaceMap.put("e4", "7b");
        replaceMap.put("f6", "7c");
        replaceMap.put("fc", "7d");
    }

    @Override
    public String getName() {
        return DATAPOINT_NAME_DISPLAY_SUBMIT;
    }

    @Override
    public void initialize(HmDevice device) {
        if (this.isDisplay(device)) {
            for (HmChannel channel : device.getChannels()) {
                if (!channel.hasDatapoint(new HmDatapointInfo(HmParamsetType.VALUES, channel, "SUBMIT"))) continue;
                int i = 1;
                while (i <= this.getLineCount(device)) {
                    this.addDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_LINE + i, HmValueType.STRING, null, false);
                    this.addEnumDisplayDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_ICON + i, Icon.class);
                    if (!this.isEpDisplay(device)) {
                        this.addEnumDisplayDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_COLOR + i, Color.class);
                    }
                    ++i;
                }
                if (this.isEpDisplay(device)) {
                    this.addEnumDisplayDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_BEEPER, Beeper.class);
                    HmDatapoint bc = this.addDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_BEEPCOUNT, HmValueType.INTEGER, 1, false);
                    bc.setMinValue(0);
                    bc.setMaxValue(15);
                    HmDatapoint bd = this.addDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_BEEPINTERVAL, HmValueType.INTEGER, 1, false);
                    bd.setMinValue(10);
                    bd.setMaxValue(160);
                    bd.setStep(10);
                    this.addEnumDisplayDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_LED, Led.class);
                }
                this.addDatapoint(device, channel.getNumber(), DATAPOINT_NAME_DISPLAY_SUBMIT, HmValueType.BOOL, false, false);
            }
        }
    }

    private void addEnumDisplayDatapoint(HmDevice device, int channelNumber, String datapointName, Class<? extends Enum<?>> e) {
        HmDatapoint dpEnum = this.addDatapoint(device, channelNumber, datapointName, HmValueType.ENUM, null, false);
        dpEnum.setOptions(this.getEnumNames(e));
        dpEnum.setMinValue(0);
        dpEnum.setMaxValue(e.getEnumConstants().length);
    }

    private String[] getEnumNames(Class<? extends Enum<?>> e) {
        return Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
    }

    private int getLineCount(HmDevice device) {
        return "HM-Dis-WM55".equals(device.getType()) ? 6 : 3;
    }

    private boolean isEpDisplay(HmDevice device) {
        return "HM-Dis-EP-WM55".equals(device.getType());
    }

    private boolean isDisplay(HmDevice device) {
        return device.getType().equals("HM-Dis-WM55") || this.isEpDisplay(device);
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        HmDevice device = dp.getChannel().getDevice();
        return !(!device.getType().equals("HM-Dis-WM55") && !this.isEpDisplay(device) || !this.getName().equals(dp.getName()) && !dp.getName().startsWith(DATAPOINT_NAME_DISPLAY_LINE) && !dp.getName().startsWith(DATAPOINT_NAME_DISPLAY_COLOR) && !dp.getName().startsWith(DATAPOINT_NAME_DISPLAY_ICON) && !dp.getName().equals(DATAPOINT_NAME_DISPLAY_LED) && !dp.getName().equals(DATAPOINT_NAME_DISPLAY_BEEPER) && !dp.getName().equals(DATAPOINT_NAME_DISPLAY_BEEPCOUNT) && !dp.getName().equals(DATAPOINT_NAME_DISPLAY_BEEPINTERVAL));
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        dp.setValue(value);
        if (DATAPOINT_NAME_DISPLAY_SUBMIT.equals(dp.getName()) && MiscUtils.isTrueValue(dp.getValue())) {
            HmChannel channel = dp.getChannel();
            boolean isEp = this.isEpDisplay(channel.getDevice());
            ArrayList<String> message = new ArrayList<String>();
            message.add(START);
            if (isEp) {
                message.add(LF);
            }
            int i = 1;
            while (i <= this.getLineCount(channel.getDevice())) {
                String icon;
                String iconCode;
                String line = ObjectUtils.toString((Object)channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_LINE + i).getValue());
                if (StringUtils.isEmpty((String)line)) {
                    line = " ";
                }
                message.add(LINE);
                message.add(this.encodeText(line));
                if (!isEp) {
                    String color = channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_COLOR + i).getOptionValue();
                    message.add(COLOR);
                    String colorCode = Color.getCode(color);
                    message.add(StringUtils.isBlank((String)colorCode) ? Color.WHITE.getCode() : colorCode);
                }
                if (StringUtils.isNotBlank((String)(iconCode = Icon.getCode(icon = channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_ICON + i).getOptionValue())))) {
                    message.add(ICON);
                    message.add(iconCode);
                }
                message.add(LF);
                ++i;
            }
            if (isEp) {
                String beeper = channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_BEEPER).getOptionValue();
                message.add(BEEPER_START);
                message.add(Beeper.getCode(beeper));
                message.add(BEEPER_END);
                message.add(this.encodeBeepCount(channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_BEEPCOUNT)));
                message.add(BEEPCOUNT_END);
                message.add(this.encodeBeepInterval(channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_BEEPINTERVAL)));
                message.add(BEEPINTERVAL_END);
                String led = channel.getDatapoint(HmParamsetType.VALUES, DATAPOINT_NAME_DISPLAY_LED).getOptionValue();
                message.add(Led.getCode(led));
            }
            message.add(STOP);
            gateway.sendDatapoint(channel.getDatapoint(HmParamsetType.VALUES, "SUBMIT"), new HmDatapointConfig(), StringUtils.join(message, (String)","), null);
        }
    }

    private String encodeBeepCount(HmDatapoint dp) {
        int counts = (Integer)((Number)dp.getValue());
        if (counts == 0) {
            counts = 16;
        }
        return String.format("0x%02x", 207 + counts);
    }

    private String encodeBeepInterval(HmDatapoint dp) {
        int interval = (Integer)((Number)dp.getValue());
        return String.format("0x%02x", 224 + (interval - 1) / 10);
    }

    private String encodeText(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append("0x");
            String hexValue = String.format("%02x", b);
            sb.append(replaceMap.containsKey(hexValue) ? replaceMap.get(hexValue) : hexValue);
            sb.append(",");
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static enum Beeper {
        OFF("0xc0"),
        LONG_LONG("0xc1"),
        LONG_SHORT("0xc2"),
        LONG_SHORT_SHORT("0xc3"),
        SHORT("0xc4"),
        SHORT_SHORT("0xc5"),
        LONG("0xc6");

        private final String code;

        private Beeper(String code) {
            this.code = code;
        }

        protected String getCode() {
            return this.code;
        }

        public static String getCode(String name) {
            try {
                return Beeper.valueOf(name).getCode();
            }
            catch (Exception exception) {
                return OFF.getCode();
            }
        }
    }

    private static enum Color {
        NONE(""),
        WHITE("0x80"),
        RED("0x81"),
        ORANGE("0x82"),
        YELLOW("0x83"),
        GREEN("0x84"),
        BLUE("0x85");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        protected String getCode() {
            return this.code;
        }

        public static String getCode(String name) {
            try {
                return Color.valueOf(name).getCode();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static enum Icon {
        NONE(""),
        OFF("0x80"),
        ON("0x81"),
        OPEN("0x82"),
        CLOSED("0x83"),
        ERROR("0x84"),
        OK("0x85"),
        INFO("0x86"),
        NEW_MESSAGE("0x87"),
        SERVICE("0x88"),
        SIGNAL_GREEN("0x89"),
        SIGNAL_YELLOW("0x8a"),
        SIGNAL_RED("0x8b");

        private final String code;

        private Icon(String code) {
            this.code = code;
        }

        protected String getCode() {
            return this.code;
        }

        public static String getCode(String name) {
            try {
                return Icon.valueOf(name).getCode();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static enum Led {
        OFF("0xf0"),
        RED("0xf1"),
        GREEN("0xf2"),
        ORANGE("0xf3");

        private final String code;

        private Led(String code) {
            this.code = code;
        }

        protected String getCode() {
            return this.code;
        }

        public static String getCode(String name) {
            try {
                return Led.valueOf(name).getCode();
            }
            catch (Exception exception) {
                return OFF.getCode();
            }
        }
    }
}

