/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class ReloadFromGatewayVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return "RELOAD_FROM_GATEWAY";
    }

    @Override
    public void initialize(HmDevice device) {
        this.addDatapoint(device, 0, this.getName(), HmValueType.BOOL, Boolean.FALSE, false);
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        dp.setValue(value);
        if (MiscUtils.isTrueValue(dp.getValue())) {
            try {
                gateway.triggerDeviceValuesReload(dp.getChannel().getDevice());
            }
            finally {
                gateway.disableDatapoint(dp, 2.0);
            }
        }
    }
}

