/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightCommunicationHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightContext;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetEchoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class LifxLightOnlineStateUpdater {
    private static final int ECHO_POLLING_INTERVAL = 15;
    private static final int MAXIMUM_POLLING_RETRIES = 3;
    private final Logger logger = LoggerFactory.getLogger(LifxLightOnlineStateUpdater.class);
    private final String logId;
    private final LifxLightHandler.CurrentLightState currentLightState;
    private final ScheduledExecutorService scheduler;
    private final LifxLightCommunicationHandler communicationHandler;
    private final ReentrantLock lock = new ReentrantLock();
    private @Nullable ScheduledFuture<?> echoJob;
    private LocalDateTime lastSeen = LocalDateTime.MIN;
    private int unansweredEchoPackets;

    public LifxLightOnlineStateUpdater(LifxLightContext context, LifxLightCommunicationHandler communicationHandler) {
        this.logId = context.getLogId();
        this.scheduler = context.getScheduler();
        this.currentLightState = context.getCurrentLightState();
        this.communicationHandler = communicationHandler;
    }

    public void sendEchoPackets() {
        block10: {
            try {
                try {
                    this.lock.lock();
                    this.logger.trace("{} : Polling light state", (Object)this.logId);
                    if (this.currentLightState.isOnline()) {
                        if (Duration.between(this.lastSeen, LocalDateTime.now()).getSeconds() > 15L) {
                            if (this.unansweredEchoPackets < 3) {
                                this.communicationHandler.sendPacket(GetEchoRequest.currentTimeEchoRequest());
                                ++this.unansweredEchoPackets;
                            } else {
                                this.currentLightState.setOfflineByCommunicationError();
                                this.unansweredEchoPackets = 0;
                            }
                        }
                        break block10;
                    }
                    if (this.communicationHandler.isBroadcastEnabled()) {
                        this.logger.trace("{} : Light is not online, broadcasting request", (Object)this.logId);
                        this.communicationHandler.broadcastPacket(new GetServiceRequest());
                        break block10;
                    }
                    this.logger.trace("{} : Light is not online, unicasting request", (Object)this.logId);
                    this.communicationHandler.sendPacket(new GetServiceRequest());
                }
                catch (Exception e) {
                    this.logger.error("Error occurred while polling the online state of a light ({})", (Object)this.logId, (Object)e);
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void start() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.addResponsePacketListener(this::handleResponsePacket);
                ScheduledFuture<?> localEchoJob = this.echoJob;
                if (localEchoJob == null || localEchoJob.isCancelled()) {
                    this.echoJob = this.scheduler.scheduleWithFixedDelay(this::sendEchoPackets, 0L, 15L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while starting online state poller for a light ({})", (Object)this.logId, (Object)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.removeResponsePacketListener(this::handleResponsePacket);
                ScheduledFuture<?> localEchoJob = this.echoJob;
                if (localEchoJob != null && !localEchoJob.isCancelled()) {
                    localEchoJob.cancel(true);
                    this.echoJob = null;
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while stopping online state poller for a light ({})", (Object)this.logId, (Object)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void handleResponsePacket(Packet packet) {
        this.lastSeen = LocalDateTime.now();
        this.unansweredEchoPackets = 0;
        this.currentLightState.setOnline();
    }
}

