/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;

public class SetLightPowerRequest
extends Packet {
    public static final int TYPE = 117;
    public static final Field<Integer> FIELD_STATE = new UInt16Field();
    public static final Field<Long> FIELD_DURATION = new UInt32Field().little();
    private PowerState state;
    private long duration;

    public PowerState getState() {
        return this.state;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public SetLightPowerRequest() {
        this.state = PowerState.OFF;
        this.duration = 0L;
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public SetLightPowerRequest(PowerState state) {
        this.state = state;
        this.duration = 0L;
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 117;
    }

    @Override
    protected int packetLength() {
        return 6;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.state = PowerState.fromValue(FIELD_STATE.value(bytes));
        this.duration = FIELD_DURATION.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_STATE.bytes(this.state.getValue())).put(FIELD_DURATION.bytes(this.duration));
    }

    @Override
    public int[] expectedResponses() {
        return new int[]{118};
    }
}

