/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelTypeProvider;
import org.eclipse.smarthome.core.thing.ChannelGroupUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinitionBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;

@NonNullByDefault
public abstract class AbstractComponent {
    protected final ChannelGroupTypeUID channelGroupTypeUID;
    protected final ChannelGroupUID channelGroupUID;
    protected final HaID haID;
    protected final Map<String, CChannel> channels = new TreeMap<String, CChannel>();
    protected final int configHash;
    protected final String configJson;
    private final Gson gson;

    public AbstractComponent(ThingUID thing, HaID haID, String configJson, Gson gson) {
        this.channelGroupTypeUID = new ChannelGroupTypeUID("mqtt", haID.getChannelGroupTypeID());
        this.channelGroupUID = new ChannelGroupUID(thing, haID.getChannelGroupID());
        this.haID = haID;
        this.configJson = configJson;
        this.configHash = configJson.hashCode();
        this.gson = gson;
    }

    public CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return this.channels.values().stream().map(v -> v.channelState.start(connection, scheduler, timeout)).reduce(CompletableFuture.completedFuture(null), (f, v) -> f.thenCompose(b -> v));
    }

    public CompletableFuture<@Nullable Void> stop() {
        return this.channels.values().stream().map(v -> v.channelState.stop()).reduce(CompletableFuture.completedFuture(null), (f, v) -> f.thenCompose(b -> v));
    }

    public void addChannelTypes(MqttChannelTypeProvider channelTypeProvider) {
        this.channels.values().forEach(v -> channelTypeProvider.setChannelType(v.channelTypeUID, v.type));
    }

    public void removeChannelTypes(MqttChannelTypeProvider channelTypeProvider) {
        this.channels.values().forEach(v -> channelTypeProvider.removeChannelType(v.channelTypeUID));
    }

    public ChannelGroupTypeUID groupTypeUID() {
        return this.channelGroupTypeUID;
    }

    public ChannelGroupUID uid() {
        return this.channelGroupUID;
    }

    public abstract String name();

    public Map<String, CChannel> channelTypes() {
        return this.channels;
    }

    public @Nullable CChannel channel(String channelID) {
        return this.channels.get(channelID);
    }

    public int getConfigHash() {
        return this.configHash;
    }

    public ChannelGroupType type() {
        List channelDefinitions = this.channels.values().stream().map(c -> new ChannelDefinitionBuilder(c.channelUID.getId(), c.channelTypeUID).build()).collect(Collectors.toList());
        return ChannelGroupTypeBuilder.instance((ChannelGroupTypeUID)this.channelGroupTypeUID, (String)this.name()).withChannelDefinitions(channelDefinitions).build();
    }

    public void resetState() {
        this.channels.values().forEach(c -> c.channelState.getCache().resetState());
    }
}

